/*! \file DoubleMatParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEMATPARAM_H_
#define _DOUBLEMATPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class DoubleMatParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmDouble* value;
		int M;
		int N;

	public:
		/*constructors, destructors: {{{1*/
		DoubleMatParam();
		DoubleMatParam(int enum_type,IssmDouble* value,int M,int N);
		~DoubleMatParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  UpdateInputsFromConstant(double constant, int name);
		void  UpdateInputsFromConstant(int constant, int name);
		void  UpdateInputsFromConstant(bool constant, int name);

		void  UpdateInputsFromSolution(double* solution){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("DoubleMat param of enum %i (%s) cannot return a bool",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(int* pinteger){ISSMERROR("DoubleMat param of enum %i (%s) cannot return an integer",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double* pdouble){ISSMERROR("DoubleMat param of enum %i (%s) cannot return a double",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("DoubleMat param of enum %i (%s) cannot return a string",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("DoubleMat param of enum %i (%s) cannot return a string arrayl",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("DoubleMat param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM,int* pN);
		void  GetParameterValue(Vec* pvec){ISSMERROR("DoubleMat param of enum %i (%s) cannot return a Vec",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("DoubleMat param of enum %i (%s) cannot return a Mat",enum_type,EnumAsString(enum_type));}

		void  SetValue(bool boolean){ISSMERROR("DoubleMat param of enum %i (%s) cannot hold a boolean",enum_type,EnumAsString(enum_type));}
		void  SetValue(int integer){ISSMERROR("DoubleMat param of enum %i (%s) cannot hold an integer",enum_type,EnumAsString(enum_type));}
		void  SetValue(double scalar){ISSMERROR("DoubleMat param of enum %i (%s) cannot hold a scalar",enum_type,EnumAsString(enum_type));}
		void  SetValue(char* string){ISSMERROR("DoubleMat param of enum %i (%s) cannot hold a string",enum_type,EnumAsString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("DoubleMat param of enum %i (%s) cannot hold a string array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* doublearray,int M){ISSMERROR("DoubleMat param of enum %i (%s) cannot hold a double vec array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* doublearray,int M,int N);
		void  SetValue(Vec vec){ISSMERROR("DoubleMat param of enum %i (%s) cannot hold a Vec",enum_type,EnumAsString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("DoubleMat param of enum %i (%s) cannot hold a Mat",enum_type,EnumAsString(enum_type));}

		char* GetParameterName(void);
		void  Process(double* partition,int numberofvertices);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _DOUBLEMATPARAM_H */
