/*!\file DoubleMatParam.c
 * \brief: implementation of the DoubleMatParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION DoubleMatParam::DoubleMatParam(){{{1*/
DoubleMatParam::DoubleMatParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleMatParam::DoubleMatParam(int enum_type,IssmDoubleMat value){{{1*/
DoubleMatParam::DoubleMatParam(int in_enum_type,double* in_value, int in_M,int in_N){

	enum_type=in_enum_type;
	M=in_M;
	N=in_N;

	value=(double*)xmalloc(M*N*sizeof(double));
	memcpy(value,in_value,M*N*sizeof(double));
}
/*}}}*/
/*FUNCTION DoubleMatParam::~DoubleMatParam(){{{1*/
DoubleMatParam::~DoubleMatParam(){
	xfree((void**)&value);
	return;
}
/*}}}*/

/*Object methods*/
/*FUNCTION DoubleMatParam::copy{{{1*/
Object* DoubleMatParam::copy() {
	
	return new DoubleMatParam(this->enum_type,this->value,this->M,this->N);

}
/*}}}*/
/*FUNCTION DoubleMatParam::DeepEcho{{{1*/
void DoubleMatParam::DeepEcho(void){

	int i,j;
	
	printf("DoubleMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);
	for(i=0;i<this->M;i++){
		for(i=0;i<this->N;i++){
			printf("%i %i %g\n",i,j,*(this->value+N*i+j));
		}
	}
}
/*}}}*/
/*FUNCTION DoubleMatParam::Demarshall{{{1*/
void  DoubleMatParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*data: */
	memcpy(&M,marshalled_dataset,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(&N,marshalled_dataset,sizeof(N));marshalled_dataset+=sizeof(N);
	value=(double*)xmalloc(M*N*sizeof(double));
	memcpy(value,marshalled_dataset,M*N*sizeof(double));marshalled_dataset+=M*N*sizeof(double);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DoubleMatParam::Echo {{{1*/
void DoubleMatParam::Echo(void){

	printf("DoubleMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);

}
/*}}}*/
/*FUNCTION DoubleMatParam::Enum{{{1*/
int DoubleMatParam::Enum(void){

	return DoubleMatParamEnum;

}
/*}}}*/
/*FUNCTION DoubleMatParam::Id{{{1*/
int    DoubleMatParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleMatParam::Marshall{{{1*/
void  DoubleMatParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleMatParam: */
	enum_value=DoubleMatParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleMatParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(marshalled_dataset,&N,sizeof(N));marshalled_dataset+=sizeof(N);
	memcpy(marshalled_dataset,value,M*N*sizeof(double));marshalled_dataset+=M*N*sizeof(double);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleMatParam::MarshallSize{{{1*/
int   DoubleMatParam::MarshallSize(){
	
	return sizeof(M)
		+sizeof(N)
		+M*N*sizeof(double)
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleMatParam::MyRank{{{1*/
int    DoubleMatParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleMatParam::GetParameterValue(double** pdoublearray,int* pM,int* pN){{{1*/
void  DoubleMatParam::GetParameterValue(double** pdoublearray,int* pM,int* pN){
	double* output=NULL;
	int M,N;

	M=this->M;
	N=this->N;
	output=(double*)xmalloc((int)(M*N*sizeof(double)));
	memcpy(output,value,M*N*sizeof(double));

	/*Assign output pointers:*/
	*pM=M;
	*pN=N;
	*pdoublearray=output;
}
/*}}}*/
/*FUNCTION DoubleMatParam::GetParameterName(void); {{{1*/
char* DoubleMatParam::GetParameterName(void){
	return  EnumAsString(this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleMatParam::ProcessParams(double* partition,int numberofvertices);{{{1*/
void  DoubleMatParam::Process(double* partition,int numberofvertices){
}
/*}}}*/
/*FUNCTION DoubleMatParam::SetMatlabField(mxArray* dataref);{{{1*/
#ifdef _SERIAL_
void  DoubleMatParam::SetMatlabField(mxArray* dataref){

	mxArray* pfield=NULL;
	mxArray* pfield2=NULL;
	double* doublemat=NULL;
	int M,N;
	char* name=NULL;
	
	name=this->GetParameterName();
	this->GetParameterValue(&doublemat,&M,&N);
				
	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,N);
	mxSetN(pfield,M);
	mxSetPr(pfield,doublemat);
	
	//transpose the matrix, written directly to matlab! from C to matlab.
	mexCallMATLAB(1,&pfield2, 1, &pfield, "'");
	mxSetField( dataref, 0, name,pfield2);
}
#endif
/*}}}*/

/*FUNCTION DoubleMatParam::UpdateInputsFromVector(double* vector, int name, int type) {{{1*/
void  DoubleMatParam::UpdateInputsFromVector(double* vector, int name, int type){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleMatParam::UpdateInputsFromVector(int* vector, int name, int type) {{{1*/
void  DoubleMatParam::UpdateInputsFromVector(int* vector, int name, int type){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleMatParam::UpdateInputsFromVector(bool* vector, int name, int type) {{{1*/
void  DoubleMatParam::UpdateInputsFromVector(bool* vector, int name, int type){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleMatParam::UpdateInputsFromConstant(double constant, int name) {{{1*/
void  DoubleMatParam::UpdateInputsFromConstant(double constant, int name){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleMatParam::UpdateInputsFromConstant(int constant, int name) {{{1*/
void  DoubleMatParam::UpdateInputsFromConstant(int constant, int name){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleMatParam::UpdateInputsFromConstant(bool constant, int name) {{{1*/
void  DoubleMatParam::UpdateInputsFromConstant(bool constant, int name){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleMatParam::SetValue(double* doublearray,int M,int N);{{{1*/
void  DoubleMatParam::SetValue(double* doublearray,int in_M,int in_N){

	/*avoid leak: */
	xfree((void**)&this->value);

	this->value=(double*)xmalloc(in_M*in_N*sizeof(double));
	memcpy(this->value,doublearray,in_M*in_N*sizeof(double));

	this->M=in_M;
	this->N=in_N;
}
/*}}}*/
