/*!\file SingVertexInput.c
 * \brief: implementation of the SingVertexInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION SingVertexInput::SingVertexInput(){{{1*/
SingVertexInput::SingVertexInput(){
	return;
}
/*}}}*/
/*FUNCTION SingVertexInput::SingVertexInput(int in_enum_type,double in_value){{{1*/
SingVertexInput::SingVertexInput(int in_enum_type,double in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION SingVertexInput::~SingVertexInput(){{{1*/
SingVertexInput::~SingVertexInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION SingVertexInput::copy{{{1*/
Object* SingVertexInput::copy() {
	
	return new SingVertexInput(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION SingVertexInput::DeepEcho{{{1*/
void SingVertexInput::DeepEcho(void){

	printf("SingVertexInput:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %g\n",this->value);
}
/*}}}*/
/*FUNCTION SingVertexInput::Demarshall{{{1*/
void  SingVertexInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION SingVertexInput::Echo {{{1*/
void SingVertexInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION SingVertexInput::Enum{{{1*/
int SingVertexInput::Enum(void){

	return SingVertexInputEnum;

}
/*}}}*/
/*FUNCTION SingVertexInput::EnumType{{{1*/
int SingVertexInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION SingVertexInput::Id{{{1*/
int    SingVertexInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION SingVertexInput::Marshall{{{1*/
void  SingVertexInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of SingVertexInput: */
	enum_value=SingVertexInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall SingVertexInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION SingVertexInput::MarshallSize{{{1*/
int   SingVertexInput::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION SingVertexInput::MyRank{{{1*/
int    SingVertexInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION SingVertexInput::SpawnSingInput{{{1*/
Input* SingVertexInput::SpawnSingInput(int index){

	/*output*/
	SingVertexInput* outinput=NULL;

	/*Create new Sing input (copy of current input)*/
	outinput=new SingVertexInput(this->enum_type,this->value);

	/*Assign output*/
	return outinput;

}
/*}}}*/
/*FUNCTION SingVertexInput::SpawnBeamInput{{{1*/
Input* SingVertexInput::SpawnBeamInput(int* indices){

	ISSMERROR("Cannot spaw a Beam from a Sing");

}
/*}}}*/
/*FUNCTION SingVertexInput::SpawnTriaInput{{{1*/
Input* SingVertexInput::SpawnTriaInput(int* indices){

	ISSMERROR("Cannot spaw a Tria from a Sing");

}
/*}}}*/
/*FUNCTION SingVertexInput::SpawnResult{{{1*/
ElementResult* SingVertexInput::SpawnResult(int step, double time){

	return new SingVertexElementResult(this->enum_type,this->value,step,time);

}
/*}}}*/

/*Object functions*/
/*FUNCTION SingVertexInput::GetParameterValue(bool* pvalue) {{{1*/
void SingVertexInput::GetParameterValue(bool* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION SingVertexInput::GetParameterValue(int* pvalue){{{1*/
void SingVertexInput::GetParameterValue(int* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION SingVertexInput::GetParameterValue(double* pvalue){{{1*/
void SingVertexInput::GetParameterValue(double* pvalue){
	*pvalue=value;
}
/*}}}*/
/*FUNCTION SingVertexInput::GetParameterValue(double* pvalue,Node* node){{{1*/
void SingVertexInput::GetParameterValue(double* pvalue,Node* node){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION SingVertexInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){{{1*/
void SingVertexInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION SingVertexInput::GetParameterValue(double* pvalue,double* gauss){{{1*/
void SingVertexInput::GetParameterValue(double* pvalue,double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION SingVertexInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){{{1*/
void SingVertexInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION SingVertexInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){{{1*/
void SingVertexInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION SingVertexInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){{{1*/
void SingVertexInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION SingVertexInput::ChangeEnum(int newenumtype){{{1*/
void SingVertexInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
/*FUNCTION SingVertexInput::GetParameterAverage(double* pvalue){{{1*/
void SingVertexInput::GetParameterAverage(double* pvalue){
	*pvalue=value;
}
/*}}}*/
/*FUNCTION SingVertexInput::SquareMin(double* psquaremin, bool process_units){{{1*/
void SingVertexInput::SquareMin(double* psquaremin, bool process_units,Parameters* parameters){

	double valuecopy;
	double squaremin;

	/*First,  copy value, to process units if requested: */
	valuecopy=value;

	/*Process units if requested: */
	if(process_units)NodalValuesUnitConversion(&valuecopy,1,enum_type,parameters);

	/*Now, return square of value, because it is the minimum: */
	squaremin=pow(valuecopy,2);
	
	/*Assign output pointers:*/
	*psquaremin=squaremin;
}
/*}}}*/
/*FUNCTION SingVertexInput::Scale(double scale_factor){{{1*/
void SingVertexInput::Scale(double scale_factor){
	value=value*scale_factor;
}
/*}}}*/
/*FUNCTION SingVertexInput::AXPY(Input* xinput,double scalar);{{{1*/
void SingVertexInput::AXPY(Input* xinput,double scalar){

	SingVertexInput*  xsingvertexinput=NULL;

	/*xinput is of the same type, so cast it: */
	xsingvertexinput=(SingVertexInput*)xinput;

	/*Carry out the AXPY operation:*/
	this->value=this->value+scalar*xsingvertexinput->value;

}
/*}}}*/
/*FUNCTION SingVertexInput::Constrain(double cm_min, double cm_max){{{1*/
void SingVertexInput::Constrain(double cm_min, double cm_max){

	if(!isnan(cm_min)) if (this->value<cm_min)this->value=cm_min;
	if(!isnan(cm_max)) if (this->value>cm_max)this->value=cm_max;

}
/*}}}*/
/*FUNCTION SingVertexInput::GetVectorFromInputs(Vec vector,int* doflist){{{1*/
void SingVertexInput::GetVectorFromInputs(Vec vector,int* doflist){

	const int numvertices=1;
	VecSetValues(vector,numvertices,doflist,(const double*)&this->value,ADD_VALUES);


}
/*}}}*/
/*FUNCTION SingVertexInput::GetValuesPtr(double** pvalues,int* pnum_values);{{{1*/
void SingVertexInput::GetValuesPtr(double** pvalues,int* pnum_values){

	*pvalues=&this->value;
	*pnum_values=1;

}
/*}}}*/
