/*!\file: transient_2d_core.cpp
 * \brief: core of the transient_2d solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"

void transient2d_core(FemModel* femmodel){

	int i;

	/*parameters: */
	int verbose=0;
	double finaltime;
	double dt;
	
	/*intermediary: */
	int    step;
	double time;

	/* recover parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&finaltime,NdtEnum);
	femmodel->parameters->FindParam(&dt,DtEnum);

	/*initialize: */
	step=0;
	time=0;

	while(time<finaltime){ //make sure we run up to finaltime.
	
		_printf_("%s%g%s%i%s%g\n","time [yr]: ",time,"    iteration number: ",step,"/",floor(finaltime/dt));

		step+=1;
		time+=dt;

		if(verbose)_printf_("%s\n","computing new velocity");
		diagnostic_core(femmodel);

		if(verbose)_printf_("%s\n","computing new thickness");
		prognostic_core(femmodel);
	
		if(verbose)_printf_("%s\n","updating geometry");
		UpdateGeometryx(femmodel->elements, femmodel->nodes,femmodel->vertices,femmodel->loads, femmodel->materials, femmodel->parameters); 

		if(verbose)_printf_("%s\n","saving results:\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VxEnum,step,time); 
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VyEnum,step,time);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,PressureEnum,step,time);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum,step,time);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceEnum,step,time);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedEnum,step,time);
	}

}
