/*!\file: balancedthickness_core.cpp
 * \brief: core of the balancedthickness solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void balancedthickness_core(FemModel* femmodel){

	/*parameters: */
	int verbose=0;
	int dim;

	/*activate formulation: */
	femmodel->SetCurrentAnalysis(BalancedthicknessAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&dim,DimEnum);

	_printf_("depth averaging velocity...\n");
	DepthAverageInputx(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VxEnum);
	DepthAverageInputx(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VyEnum);
	if(dim==3) DepthAverageInputx(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VzEnum);

	_printf_("call computational core:\n");
	solver_linear(NULL,femmodel);

	_printf_("extrude computed thickness on all layers:\n");
	ExtrudeInputx(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,ThicknessEnum);

	if(verbose)_printf_("saving results:\n");
	InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);

}
