/*!\file: steadystateconvergence.cpp
 * \brief: determine convergence of steady state solution
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

int steadystateconvergence(FemModel* femmodel){
	
	/*output: */
	int converged=0;
	int velocity_converged=0;
	int temperature_converged=0;

	/*intermediary: */
	int velocityenums[8]={VxEnum,OldVxEnum,VyEnum,OldVyEnum,VzEnum,OldVzEnum,PressureEnum,OldPressureEnum}; //pairs of enums (new and old) on which to carry out the converence tests
	int temperatureenums[2]={TemperatureEnum,OldTemperatureEnum};
	int convergencecriterion[1]={RelativeEnum}; //criterions for convergence, RelativeEnum or AbsoluteEnum 
	int convergencecriterionvalue[1]; //value of criterion to be respected

	/*retrieve parameters: */
	femmodel->parameters->FindParam(&convergencecriterionvalue[0],EpsRelEnum);
	
	/*figure out convergence at the input level, because we don't have the solution vectors!: */
	velocity_converged=InputConvergencex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,velocityenums,8,convergencecriterion,convergencecriterionvalue,1);
	temperature_converged=InputConvergencex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,temperatureenums,2,convergencecriterion,convergencecriterionvalue,1);

	if(velocity_converged && temperature_converged)converged=1;

	/*return: */
	return converged;

}
