/*!\file: numerics.h
 * \brief prototypes for numerics.h
 */ 

#ifndef _NUMERICS_H_
#define  _NUMERICS_H_

#include "./GaussPoints.h"
#include "./isnan.h"
class Input;

struct OptArgs;
struct OptPars;

double min(double a,double b);
double max(double a,double b);
double OptFunc(double scalar, OptArgs* optargs);
void   BrentSearch(double* psearch_scalar,double* pJ,OptPars* optpars,double (*f)(double,OptArgs*), OptArgs* optargs);
void   cross(double* result,double* vector1,double* vector2);
double norm(double* vector);
void IsInputConverged(double* peps, Input** new_inputs,Input** old_inputs,int num_inputs,int criterion_enum);

#endif //ifndef _NUMERICS_H_

