/*!\file Orthx
 * \brief orthogonalize searching directions for inverse control methods
 */

#include "./Orthx.h"

void	Orthx( Vec* pnewgradj, Vec gradj, Vec oldgradj){
	
	/*output: */
	Vec newgradj=NULL;

	/*intermediary:*/
	double norm_new,norm_old,dot_product;;

	/*Initialize output*/
	VecDuplicate(gradj,&newgradj);
	VecCopy(gradj,newgradj);

	/*rough orthagonalization
	gradient=gradient-(gradient'*oldgradient)*oldgradient /norm(oldgradient)^2; */
	if(oldgradj){
		VecNorm(oldgradj,NORM_2,&norm_old);
		VecDot(newgradj,oldgradj,&dot_product);
		VecAXPY(newgradj, -dot_product/pow(norm_old,2), oldgradj);
	}

	/*scale to 1: gradient=gradient/max(abs(gradient))*/
	VecNorm(newgradj,NORM_INFINITY,&norm_new);
	if (norm_new<=0){
		ISSMERROR("||∂J/∂α||∞ = 0  gradient is zero");
	}
	VecScale(newgradj,1.0/norm_new);

	/*Assign correct pointer*/
	*pnewgradj=newgradj;
}
