/*!\file: controlrestart.cpp
 * \brief: save as much as possible, to be able to restart the control_core solution
 */ 

#include "./solutions.h"
#include "../modules/modules.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void controlrestart(FemModel* femmodel){

	char*    outputfilename=NULL;
	
	/*retrieve output file name: */
	model->FindParam(&outputfilename,OutputFileNameEnum);

	/*we essentially want J and the parameter: */
	InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,control_type); //the parameter itself!
	femmodel->otherresults->AddObject(new DoubleResult(femmodel->otherresults->Size()+1,0,1,"J",J,nsteps));
	femmodel->otherresults->AddObject(new StringResult(results->Size()+1,ControlTypeEnum,0,1,EnumAsString(control_type)));

	/*write to disk: */
	OutputResults(femmodel->elements, femmodel->loads, femmodel->nodes, femmodel->vertices, femmodel->materials, femmodel->parameters, outputfilename);
	
	/*Free ressources:*/
	xfree((void**)&outputfilename);
}
