/*!\file: stokescontrolinit.cpp
 * \brief: ...
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void stokescontrolinit(FemModel* femmodel){

	/*flags: */
	int verbose=0;
	int isstokes=0;
	double stokesreconditioning;

	/*first recover parameters common to all solutions:*/
	model->FindParam(&verbose,VerboseEnum);
	model->FindParam(&isstokes,IsStokesEnum);
	model->FindParam(&stokesreconditioning,StokesReconditioningEnum);

	/*if no Stokes analysis carried out, assign output and return*/
	if (!isstokes)femmodel->SetAnalysisType(DiagnosticAnalysisEnum,DiagnosticHorizAnalysisEnum);

	/* For Stokes inverse control method, we are going to carry out the inversion only on the Stokes part. So we need 
	 * to solve the Hutter or MacAyeal/Pattyn model here, and constrain the Stokes model using the Hutter 
	 * or MacAyeal/Pattyn at the boundary. We don't want to have to do that at every inversion step, as 
	 * it needs be done only once: */

	/*Compute slopes: */
	bedslope_core(femmodel);
	
	/*Run a complete diagnostic to update the Stokes spcs: */
	solver_diagnostic_nonlinear(NULL,NULL,NULL,femmodel,false,DiagnosticAnalysisEnum,HorizAnalysisEnum); //false means we expose loads to changes inside the solution

	//vertical velocity
	solver_linear(NULL,femmodel,DiagnosticAnalysisEnum,VertAnalysisEnum);

	//recondition" pressure computed previously:
	DuplicateInputx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,PressureEnum,PressureStokesEnum);
	ScaleInputx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,PressureStokesEnum,1.0/stokesreconditioning);

	if(verbose)_printf_("%s\n"," update boundary conditions for stokes using velocities previously computed...");
	ResetBoundaryConditions(femmodel,DiagnosticAnalysisEnum,StokesAnalysisEnum);

	if(verbose)_printf_("%s\n"," computing stokes velocities and pressure ...");
	solver_diagnostic_nonlinear(NULL,NULL,NULL,NULL,femmodel,DiagnosticAnalysisEnum,StokesAnalysisEnum);

	/*Assign output*/
	model->SetActiveFormulation(fem_ds);
}
