/*
 * solutions.h: 
 */

#ifndef SOLUTIONS_H_
#define SOLUTIONS_H_

#include "../objects/objects.h"
#include "../io/io.h"

struct OptArgs;
class FemModel;

/*cores: */
Results* prognostic_core(FemModel* femmodel);
Results* prognostic2_core(FemModel* femmodel);
Results* balancedthickness_core(FemModel* femmodel);
Results* balancedthickness2_core(FemModel* femmodel);
Results* balancedvelocities_core(FemModel* femmodel);
Results* slopecompute_core(FemModel* femmodel);
Results* steadystate_core(FemModel* femmodel);
Results* transient_core(FemModel* femmodel);
Results* transient_core_2d(FemModel* femmodel);
Results* transient_core_3d(FemModel* femmodel);
void adjoint_core(FemModel* femmodel);
void gradient_core(FemModel* femmodel,int step=0, double search_scalar=0);
void diagnostic_core(FemModel* femmodel);
void thermal_core(FemModel* femmodel);
void surfaceslope_core(FemModel* femfemmodel);
void bedslope_core(FemModel* femfemmodel);
void control_core(FemModel* femmodel);

//int GradJOrth(WorkspaceParams* workspaceparams);
void convergence(int* pconverged, Mat K_ff,Vec p_f,Vec u_f,Vec u_f_old,Parameters* parameters);
int controlconvergence(double* J, double* fit, double eps_cm, int n);

int GoldenSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femfemmodel);

int BrentSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femfemmodel);
	
double objectivefunctionC(double search_scalar,OptArgs* optargs);

int GradJSearch(double* search_vector,FemModel* femfemmodel,int step);
//int GradJCheck(WorkspaceParams* workspaceparams,int step,int status);

//int ParameterUpdate(double* search_vector,int step, WorkspaceParams* workspaceparams,BatchParams* batchparams);
void WriteLockFile(char* filename);

void stokescontrolinit(FemModel* femfemmodel);
void controlrestart(FemModel* femfemmodel);

void CreateFemModel(FemModel* femfemmodel,ConstDataHandle MODEL,int analysis_type,int sub_analysis_type);
//int BatchDebug(Mat* Kgg,Vec* pg,FemModel* femfemmodel,char* filename);
void ResetBoundaryConditions(FemModel* femfemmodel, int analysis_type, int sub_analysis_type);

#endif
