/*!\file DoubleVecParam.c
 * \brief: implementation of the DoubleVecParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION DoubleVecParam::DoubleVecParam(){{{1*/
DoubleVecParam::DoubleVecParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleVecParam::DoubleVecParam(int enum_type,IssmDoubleVec values,int M){{{1*/
DoubleVecParam::DoubleVecParam(int in_enum_type,double* in_values, int in_M){

	enum_type=in_enum_type;
	M=in_M;

	values=(double*)xmalloc(M*sizeof(double));
	memcpy(values,in_values,M*sizeof(double));
}
/*}}}*/
/*FUNCTION DoubleVecParam::~DoubleVecParam(){{{1*/
DoubleVecParam::~DoubleVecParam(){
	xfree((void**)&values);
	return;
}
/*}}}*/

/*Object methods*/
/*FUNCTION DoubleVecParam::copy{{{1*/
Object* DoubleVecParam::copy() {
	
	return new DoubleVecParam(this->enum_type,this->values,this->M);

}
/*}}}*/
/*FUNCTION DoubleVecParam::DeepEcho{{{1*/
void DoubleVecParam::DeepEcho(void){

	int i;
	
	printf("DoubleVecParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   vector size: %i\n",this->M);
	for(i=0;i<this->M;i++){
		printf("%i %g\n",i,this->values[i]);
	}
}
/*}}}*/
/*FUNCTION DoubleVecParam::Demarshall{{{1*/
void  DoubleVecParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*data: */
	memcpy(&M,marshalled_dataset,sizeof(M));marshalled_dataset+=sizeof(M);
	values=(double*)xmalloc(M*sizeof(double));
	memcpy(values,marshalled_dataset,M*sizeof(double));marshalled_dataset+=M*sizeof(double);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DoubleVecParam::Echo {{{1*/
void DoubleVecParam::Echo(void){

	printf("DoubleVecParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   vector size: %i\n",this->M);

}
/*}}}*/
/*FUNCTION DoubleVecParam::Enum{{{1*/
int DoubleVecParam::Enum(void){

	return DoubleVecParamEnum;

}
/*}}}*/
/*FUNCTION DoubleVecParam::Id{{{1*/
int    DoubleVecParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleVecParam::Marshall{{{1*/
void  DoubleVecParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleVecParam: */
	enum_value=DoubleVecParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleVecParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(marshalled_dataset,values,M*sizeof(double));marshalled_dataset+=M*sizeof(double);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleVecParam::MarshallSize{{{1*/
int   DoubleVecParam::MarshallSize(){
	
	return sizeof(M)
		+M*sizeof(double)
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleVecParam::MyRank{{{1*/
int    DoubleVecParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleVecParam::GetParameterValue(double** pdoublearray,int* pM){{{1*/
void  DoubleVecParam::GetParameterValue(double** pdoublearray,int* pM){
	double* output=NULL;
	int M;


	M=this->M;
	output=(double*)xmalloc(M*sizeof(double));
	memcpy(output,values,M*sizeof(double));

	/*Assign output pointers:*/
	*pM=M;
	*pdoublearray=output;
}
/*}}}*/
/*FUNCTION DoubleVecParam::GetParameterName(void); {{{1*/
char* DoubleVecParam::GetParameterName(void){
	return  EnumAsString(this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleVecParam::ProcessParams(double* partition,int numberofvertices);{{{1*/
void  DoubleVecParam::Process(double* partition,int numberofvertices) {

	int i;
	double* newvalues=NULL;

	/*This param holds a vector of size numberofvertices, which means we are being asked to 
	 * repartition it: */
	
	if(this->M==numberofvertices){

		newvalues=(double*)xmalloc(this->M*sizeof(double));
				
		for(i=0;i<this->M;i++){
			newvalues[(int)(partition[i])]=this->values[i];
		}

		/*Reassign values to new values: */
		xfree((void**)&this->values);
		this->values=newvalues;
	}

}
/*}}}*/
/*FUNCTION DoubleVecParam::SetMatlabField(mxArray* dataref);{{{1*/
#ifdef _SERIAL_
void  DoubleVecParam::SetMatlabField(mxArray* dataref){

	char* name=NULL;
	double* doublevec=NULL;
	int M;
	mxArray* pfield=NULL;

	this->GetParameterValue(&doublevec,&M);
	name=this->GetParameterName();
				
	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,M);
	mxSetN(pfield,1);
	mxSetPr(pfield,doublevec);
	
	mxSetField( dataref, 0, name, pfield);
}
#endif
/*}}}*/

/*FUNCTION DoubleVecParam::UpdateInputsFromVector(double* vector, int name, int type) {{{1*/
void  DoubleVecParam::UpdateInputsFromVector(double* vector, int name, int type){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleVecParam::UpdateInputsFromVector(int* vector, int name, int type) {{{1*/
void  DoubleVecParam::UpdateInputsFromVector(int* vector, int name, int type){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleVecParam::UpdateInputsFromVector(bool* vector, int name, int type) {{{1*/
void  DoubleVecParam::UpdateInputsFromVector(bool* vector, int name, int type){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleVecParam::UpdateInputsFromConstant(double constant, int name) {{{1*/
void  DoubleVecParam::UpdateInputsFromConstant(double constant, int name){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleVecParam::UpdateInputsFromConstant(int constant, int name) {{{1*/
void  DoubleVecParam::UpdateInputsFromConstant(int constant, int name){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION DoubleVecParam::UpdateInputsFromConstant(bool constant, int name) {{{1*/
void  DoubleVecParam::UpdateInputsFromConstant(bool constant, int name){
	/*Nothing updated yet*/
}
/*}}}*/
