/*!\file IntExternalResult.c
 * \brief: implementation of the IntExternalResult object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION IntExternalResult::IntExternalResult(){{{1*/
IntExternalResult::IntExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION IntExternalResult::IntExternalResult(int enum_type,double value){{{1*/
IntExternalResult::IntExternalResult(int in_id, int in_enum_type,int in_value,int in_step, double in_time){

	id=in_id;
	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION IntExternalResult::~IntExternalResult(){{{1*/
IntExternalResult::~IntExternalResult(){
	return;
}
/*}}}*/

/*Object methods*/
/*FUNCTION IntExternalResult::copy{{{1*/
Object* IntExternalResult::copy() {
	
	return new IntExternalResult(this->id,this->enum_type,this->value,this->step,this->time);

}
/*}}}*/
/*FUNCTION IntExternalResult::DeepEcho{{{1*/
void IntExternalResult::DeepEcho(void){

	printf("IntExternalResult:\n");
	printf("   id: %i\n",this->id);
	printf("   enum:  %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %i\n",this->value);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION IntExternalResult::Demarshall{{{1*/
void  IntExternalResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION IntExternalResult::Echo {{{1*/
void IntExternalResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION IntExternalResult::Enum{{{1*/
int IntExternalResult::Enum(void){

	return IntExternalResultEnum;

}
/*}}}*/
/*FUNCTION IntExternalResult::Id{{{1*/
int    IntExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntExternalResult::Marshall{{{1*/
void  IntExternalResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of IntExternalResult: */
	enum_value=IntExternalResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall IntExternalResult data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION IntExternalResult::MarshallSize{{{1*/
int   IntExternalResult::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(id)
		+sizeof(enum_type)
		+sizeof(step)
		+sizeof(time)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION IntExternalResult::MyRank{{{1*/
int    IntExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
