/*! \file DoubleElementResult.h 
 *  \brief: header file for double result object
 *  A double result object is just derived from a DoubleInput object, with additional time and step information.
 */


#ifndef _DOUBLEELEMENTRESULT_H_
#define _DOUBLEELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
class Parameters;
/*}}}*/

class DoubleElementResult: public DoubleInput,public ElementResult{

	private: 
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		DoubleElementResult();
		DoubleElementResult(int enum_type,IssmDouble value,int step,double time);
		~DoubleElementResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

				/*}}}*/
		/*result virtual functions: {{{1*/
		ElementResult* SpawnSingElementResult(int  index);
		ElementResult* SpawnBeamElementResult(int* indices);
		ElementResult* SpawnTriaElementResult(int* indices);
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/

};
#endif  /* _DOUBLEELEMENTRESULT_H */
