/*!\file ControlContrainInputx
 * \brief: Y=Y+aX operation on inputs.
 */

#include "./ControlContrainInputx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void ControlContrainInputx(DataSet* elements,DataSet* nodes,DataSet* vertices,DataSet* loads,DataSet* materials,Parameters* parameters,int control_type,double cm_min, double cm_max){

	/*intermediary:*/
	int      i;

    /*some early returns: */
	if(isnan(cm_min) & isnan(cm_max))return;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elemnets, and ask to carry out the ControlContrain operation on inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->ControlContrainInput(control_type,cm_min,cm_max);
	}
}
