/*!\file:  gradient_core.cpp
 * \brief compute inverse method gradient direction.
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"


void gradient_core(FemModel* femmodel){
	
	
	/*parameters: */
	int control_steady;
	int control_type;
	int verbose;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&control_steady,ControlSteadyEnum);
	femmodel->parameters->FindParam(&control_type,ControlTypeEnum);
	femmodel->parameters->FindParam(&verbose,VerboseEnum);

	if(verbose)_printf_("%s\n","      compute adjoint state:");
	adjoint_core(femmodel);
	
	if(verbose)_printf_("%s\n","      compute gradient:");
	Gradjx( femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters, control_type);

	if(control_steady)diagnostic_core(model);

}
