/*!\file Gradjx
 * \brief: compute inverse method gradient
 */

#include "./Gradjx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void Gradjx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,int control_type){

	int i;
	int dim;


	/*First, get elements and loads configured: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*retrieve some parameters: */
	parameters->FindParam(&dim,DimEnum);


	/*Compute gradients: */
	for (i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->Gradj(control_type);
	}

	/*Extrude if needed: */
	if(dim==3) InputsExtrudex( elements,nodes,vertices,loads,materials,parameters,GradientEnum,0);

}
