/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{

	/*Datasets {{{1*/
	ConstraintsEnum,
	DatasetsEnum,
	ElementsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	ResultsEnum,
	VerticesEnum,
	/*}}}*/
	/*Solution types {{{1 */
	SolutionTypeEnum,
	DiagnosticSolutionEnum,
	SurfaceSlopeSolutionEnum,
	BedSlopeSolutionEnum,
	/*}}}*/
	/*Analysis types {{{1 */
	AnalysisTypeEnum,
	SubAnalysisTypeEnum,
	AnalysisCounterEnum,
	//diagnostic
	DiagnosticAnalysisEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticVertAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	DiagnosticStokesAnalysisEnum,
	HorizAnalysisEnum,
	HutterAnalysisEnum,
	StokesAnalysisEnum,
	VertAnalysisEnum,
	//control
	AdjointAnalysisEnum,
	ControlAnalysisEnum,
	GradientAnalysisEnum,
	InverseAnalysisEnum,
	//thermal
	ThermalAnalysisEnum,
	//transient
	TransientAnalysisEnum,
	SteadyAnalysisEnum,
	//slope
	SlopeComputeAnalysisEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	//prognostic
	Balancedthickness2AnalysisEnum,
	BalancedthicknessAnalysisEnum,
	BalancedvelocitiesAnalysisEnum,
	Prognostic2AnalysisEnum,
	PrognosticAnalysisEnum,
	//melting
	MeltingAnalysisEnum,
	//mesh2grid
	Mesh2gridAnalysisEnum,
	//parameters
	ParametersAnalysisEnum,
	//steadystate
	SteadystateAnalysisEnum,
	//none
	NoneAnalysisEnum,
	/*}}}*/
	/*Formulations {{{1*/
	FormulationEnum,
	HutterFormulationEnum,
	MacAyealFormulationEnum,
	NoneFormulationEnum,
	PattynFormulationEnum,
	StokesFormulationEnum,
	/*}}}*/
	/*Objects {{{1*/
	ObjectEnum,
	HookEnum,
	/*Elements: */
	ElementEnum,
	BeamEnum,
	DofIndexingEnum,
	ElementPropertiesEnum,
	NodePropertiesEnum,
	PentaEnum,
	SingEnum,
	TriaEnum,
	/*Grids: */
	NodeEnum,
	VertexEnum,
	/*Loads: */
	LoadEnum,
	IcefrontEnum,
	NumericalfluxEnum,
	PengridEnum,
	PenpairEnum,
	QuadIceFrontEnum,
	QuadRiftFrontEnum,
	RiftfrontEnum,
	SegmentIcefrontEnum,
	SegmentRiftfrontEnum,
	/*Materials: */
	MaterialEnum,
	MaticeEnum,
	MatparEnum,
	/*Inputs: */
	InputEnum,
	BeamVertexInputEnum,
	BoolInputEnum,
	DoubleInputEnum,
	IntInputEnum,
	PentaVertexInputEnum,
	SingVertexInputEnum,
	TriaVertexInputEnum,
	/*Params: */
	ParamEnum,
	BoolParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	IntParamEnum,
	PetscMatParamEnum,
	PetscVecParamEnum,
	StringArrayParamEnum,
	StringParamEnum,
	/*Results: */
	ResultEnum,
	/*Rgb: */
	RgbEnum,
	/*Spc: */
	SpcEnum,
	/*DofVec: */
	DofVecEnum,
	/*}}}*/
	/*Geography {{{1*/
	GeographyEnum,
	IceSheetEnum,
	IceShelfEnum,
	/*}}}*/
	/*Fill {{{1*/
	WaterEnum,
	IceEnum,
	AirEnum,
	MelangeEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AccumulationRateEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	ArtDiffEnum,
	BedEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	CmMaxDmpSlopeEnum,
	CmMaxDmpValueEnum,
	CmMinDmpSlopeEnum,
	CmMinDmpValueEnum,
	CmNoiseDmpEnum,
	CollapseEnum,
	ConstantEnum,
	ControlTypeEnum,
	ConvergedEnum,
	DhDtEnum,
	DragCoefficientEnum,
	DragPEnum,
	DragQEnum,
	DragTypeEnum,
	DtEnum,
	ElementOnBedEnum,
	ElementOnIceShelfEnum,
	ElementOnSurfaceEnum,
	ElementOnWaterEnum,
	EpsVelEnum,
	FillEnum,
	FitEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GeothermalFluxEnum,
	InternalEnum,
	KflagEnum,
	MaxPenetrationEnum,
	MeanVelEnum,
	MeltingOffsetEnum,
	MeltingRateEnum,
	NodeOnBedEnum,
	NodeOnIceSheetEnum,
	NodeOnIceShelfEnum,
	NodeOnSurfaceEnum,
	NumberNodeToElementConnectivityEnum,
	PenaltyOffsetEnum,
	PflagEnum,
	PressureEnum,
	PressureOldEnum,
	QmuPressureEnum,
	PressureStokesEnum,
	ResetPenaltiesEnum,
	RheologyBEnum,
	RheologyNEnum,
	SegmentOnIceShelfEnum,
	StabilizeConstraintsEnum,
	StokesReconditioningEnum,
	SurfaceAreaEnum,
	SurfaceEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperatureAverageEnum,
	ThicknessEnum,
	TypeEnum,
	ViscosityOvershootEnum,
	VxAverageEnum,
	VxEnum,
	VxObsEnum,
	VxOldEnum,
	QmuVxEnum,
	VyAverageEnum,
	VyEnum,
	VyObsEnum,
	VyOldEnum,
	QmuVyEnum,
	VzAverageEnum,
	VzEnum,
	VzObsEnum,
	VzOldEnum,
	QmuVzEnum,
	WeightsEnum,
	/*}}}*/
	/*Element types{{{1*/
	P0Enum,
	P1Enum,
	/*}}}*/
	/*Results{{{1*/
	DoubleResultEnum,
	TriaVertexResultEnum,
	PentaVertexResultEnum,
	SingVertexResultEnum,
	BeamVertexResultEnum,
	/*}}}*/
	/*Parameters{{{1*/
	BetaEnum,
	CmGradientEnum,
	CmJumpEnum,
	CmMaxEnum,
	CmMinEnum,
	GradientEnum,
	ConnectivityEnum,
	ControlParameterEnum,
	ControlSteadyEnum,
	DakotaParameterEnum,
	DimEnum,
	EpsAbsEnum,
	EpsCmEnum,
	EpsRelEnum,
	EpsResEnum,
	ExtrudeParamEnum,
	HeatCapacityEnum,
	IsHutterEnum,
	IsMacAyealPattynEnum,
	IsStokesEnum,
	LatentHeatEnum,
	LowmemEnum,
	MaxIterEnum,
	MaxNonlinearIterationsEnum,
	MeltingPointEnum,
	MinMechanicalConstraintsEnum,
	MinThermalConstraintsEnum,
	NStepsEnum,
	NdtEnum,
	NumOutputEnum,
	NumRiftsEnum,
	NumberOfDofsPerNodeEnum,
	NumberOfElementsEnum,
	NumberOfNodesEnum,
	NumberOfVerticesEnum,
	OptScalEnum,
	OutputFileNameEnum,
	ParameterOutputEnum,
	PenaltyMeltingEnum,
	QmuAnalysisEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuMassFluxSegmentsEnum,
	QmuNPartEnum,
	QmuOutNameEnum,
	QmuPartEnum,
	ResponseDescriptorsEnum,
	SolverStringEnum,
	SparsityEnum,
	TolXEnum,
	VariableDescriptorsEnum,
	VerboseEnum,
	WaitOnLockEnum,
	YtsEnum
	/*}}}*/
};

/*Functions on enums: */
int EnumIsElement(int en);
int EnumIsLoad(int en);
int EnumIsMaterial(int en);
char* EnumAsString(int enum_type);
int StringAsEnum(char* string);

#endif
