/*!\file ReinitializeInputx
 * \brief: reinitialize an input inside the elements, so that QMU runs can be carried out.
 */

#include "./ReinitializeInputx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void ReinitializeInputx(DataSet* elements,DataSet* nodes,DataSet* vertices,DataSet* loads,DataSet* materials,Parameters* parameters,int reinitialized_enum, int original_enum){

	/*intermediary:*/
	int      i;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elemnets, and ask to reinitialie the input: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->ReinitializeInput(reinitialized_enum,original_enum);
	}

}
