/*!\file: surfaceslope_core.cpp
 * \brief: core of the slope solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../solvers/solvers.h"
#include "../modules/modules.h"

void surfaceslope_core(FemModel* femmodel){

	/*parameters: */
	int verbose;
	int dim;
	bool isstokes;
	bool ishutter;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&dim,DimEnum);

	if(verbose)_printf_("%s\n","computing slope...");

	/*Call on core computations: */
	solver_linear(NULL,femmodel,SlopeComputeAnalysisEnum,SurfaceSlopeXAnalysisEnum);
	solver_linear(NULL,femmodel,SlopeComputeAnalysisEnum,SurfaceSlopeYAnalysisEnum);
	
	/*extrude inputs if we are in 3D: */
	if (dim==3){
		if(verbose)_printf_("%s\n","extruding slope in 3d...");
		InputsExtrudex( femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceSlopeXEnum,0);
		InputsExtrudex( femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceSlopeYEnum,0);
	}
}
