/*
 * solutions.h: 
 */

#ifndef SOLUTIONS_H_
#define SOLUTIONS_H_

#include "../objects/objects.h"
#include "../io/io.h"

struct OptArgs;
class FemModel;

/*cores: */
Results* gradjcompute_core(FemModel* model);
void diagnostic_core(FemModel* model);
Results* prognostic_core(FemModel* model);
Results* prognostic2_core(FemModel* model);
Results* balancedthickness_core(FemModel* model);
Results* balancedthickness2_core(FemModel* model);
Results* balancedvelocities_core(FemModel* model);
Results* slopecompute_core(FemModel* model);
Results* control_core(FemModel* model);
Results* steadystate_core(FemModel* model);
Results* transient_core(FemModel* model);
Results* transient_core_2d(FemModel* model);
Results* transient_core_3d(FemModel* model);
Results* thermal_core(FemModel* model);
void surfaceslope_core(FemModel* femmodel);
void bedslope_core(FemModel* femmodel);

//int GradJOrth(WorkspaceParams* workspaceparams);
void convergence(int* pconverged, Mat K_ff,Vec p_f,Vec u_f,Vec u_f_old,Parameters* parameters);

int GoldenSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femmodel);

int BrentSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femmodel);
	
double objectivefunctionC(double search_scalar,OptArgs* optargs);

int GradJSearch(double* search_vector,FemModel* femmodel,int step);
//int GradJCheck(WorkspaceParams* workspaceparams,int step,int status);

//int ParameterUpdate(double* search_vector,int step, WorkspaceParams* workspaceparams,BatchParams* batchparams);
void WriteLockFile(char* filename);

void ControlInitialization(FemModel* model);
void ControlRestart(FemModel* model,double* param_g);

void CreateFemModel(FemModel* femmodel,ConstDataHandle MODEL,int analysis_type,int sub_analysis_type);
//int BatchDebug(Mat* Kgg,Vec* pg,FemModel* femmodel,char* filename);
void ResetBoundaryConditions(FemModel* femmodel, int analysis_type, int sub_analysis_type);

#endif
