/*!\file: balancedthickness_core.cpp
 * \brief: core of the balancedthickness solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

Results* balancedthickness_core(Model* model){

	extern int my_rank;

	/*output: */
	Results* results=NULL;
	Result* result=NULL;

	/*intermediary: */
	Vec u_g=NULL;

	/*solutions: */
	Vec h_g=NULL;

	/*flags: */
	int verbose=0;
	int numberofdofspernode;
	int numberofnodes;
	int dofs[2]={1,1};

	/*fem balancedthickness model: */
	FemModel* fem_p=NULL;

	//initialize results:
	results=new Results();

	/*recover fem model: */
	fem_p=model->GetFormulation(BalancedthicknessAnalysisEnum);

	//first recover parameters common to all solutions
	model->FindParam(&verbose,VerboseEnum);
	model->FindParam(&numberofnodes,NumberOfNodesEnum);
	model->FindParam(&numberofdofspernode,NumberOfDofsPerNodeEnum);

	_printf_("depth averaging velocity...\n");
	//u_g=inputs->Get("velocity",&dofs[0],2); //take (vx,vy) from inputs velocity
	//FieldDepthAveragex( u_g, fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,"velocity");
	//inputs->Add("velocity_average",u_g,2,numberofnodes);
	ISSMERROR("not supported yet!");
	
	_printf_("call computational core:\n");
	diagnostic_core_linear(&h_g,fem_p,BalancedthicknessAnalysisEnum,NoneAnalysisEnum);

	_printf_("extrude computed thickness on all layers:\n");
	FieldExtrudex( h_g, fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,"thickness",0);

	/*Plug results into output dataset: */
	InputToResultx(&result,fem_p->elements,fem_p->nodes,fem_p->vertices, fem_p->loads, fem_p->materials,fem_p->parameters,ThicknessEnum,results->Size()+1,0,1); results->AddObject(result);
	results->AddObject(new StringResult(results->Size()+1,AnalysisTypeEnum,0,1,EnumAsString(BalancedthicknessAnalysisEnum)));

	/*Free ressources:*/
	VecFree(&u_g);
	VecFree(&h_g);
	
	/*return: */
	return results;

}
