/*! \file Vertex.h 
 *  \brief: header file for vertex object
 */

#ifndef _VERTEX_H_
#define _VERTEX_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "./DofObject.h"
class IoModel;
#include "../shared/Exceptions/exceptions.h"
#include "../include/include.h"

/*}}}*/


class Vertex: public Object,public DofObject{

	public: 

		int  id;
		double x;
		double y;
		double z;
		double sigma; //sigma coordinate: (z-bed)/thickness

		/*dof management: */
		int    clone;
		int    dof; //dof to recover values in a vertex indexed vector

		/*FUNCTION constructors, destructors {{{1*/
		Vertex();
		Vertex(int id, double x, double y, double z, double sigma); 
		void Init(int id, double x, double y, double z, double sigma);
		Vertex(int id, int i, IoModel* iomodel);
		~Vertex();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(void); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateFromDakota(void* vinputs);
		void  UpdatePosition(double* thickness,double* bed);
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  UpdateInputsFromConstant(double constant, int name);
		void  UpdateInputsFromConstant(int constant, int name);
		void  UpdateInputsFromConstant(bool constant, int name);

		void  UpdateInputsFromSolution(double* solution){ISSMERROR("Not implemented yet!");}


		/*}}}*/
		/*FUNCTION DofObject routines {{{1*/
		void  DistributeDofs(int* pdofcount);
		void  OffsetDofs(int dofcount);
		void  ShowTrueDofs(int* borderdofs);
		void  UpdateCloneDofs(int* allborderdofs);
		void  SetClone(int* minranks);
		void  CreatePartition(Vec partition);
		/*}}}*/

};
#endif  /* _VERTEX_H */
