/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 


#ifndef _ELEMENT_H_
#define _ELEMENT_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"

class DataSet;
class Parameters;
class Patch;

#include "../../toolkits/toolkits.h"
/*}}}*/

class Element: public Object{

	public: 
		
		virtual        ~Element(){};
		virtual void   Configure(DataSet* elements,DataSet* loads,DataSet* nodes,DataSet* materials,Parameters* parameters)=0;
		
		virtual void   CreateKMatrix(Mat Kgg)=0;
		virtual void   CreatePVector(Vec pg)=0;
		virtual void   GetSolutionFromInputs(Vec solution)=0;
		virtual void   GetNodes(void** nodes)=0;
		virtual void*  GetMatPar()=0;
		virtual bool   GetShelf()=0; 
		virtual bool   GetOnBed()=0;
		virtual void   GetThicknessList(double* thickness_list)=0;
		virtual void   GetBedList(double* bed_list)=0;
		virtual void   Du(Vec du_g)=0;
		virtual void   Gradj(Vec grad_g,int control_type)=0;
		virtual void   GradjDrag(Vec grad_g)=0;
		virtual void   GradjB(Vec grad_g)=0;
		virtual double Misfit(void)=0;
		virtual double CostFunction(void)=0;
		virtual double SurfaceArea(void)=0;
		virtual void   DepthAverageInputAtBase(int enum_type)=0;
		virtual void   ComputeBasalStress(Vec sigma_b)=0;
		virtual void   ComputePressure(Vec p_g)=0;
		virtual void   ComputeStrainRate(Vec eps)=0;
		virtual double MassFlux(double* segment)=0;
		virtual void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes)=0;
		virtual void   PatchFill(int* pcount, Patch* patch)=0;
		virtual void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type)=0;
		virtual void   InputToResult(int enum_type,int step,double time)=0;
		virtual void   ProcessResultsUnits(void)=0;
		virtual void   MinVel(double* pminvel, bool process_units)=0;
		virtual void   MaxVel(double* pmaxvel, bool process_units)=0;
		virtual void   MinVx(double* pminvx, bool process_units)=0;
		virtual void   MaxVx(double* pmaxvx, bool process_units)=0;
		virtual void   MaxAbsVx(double* pmaxabsvx, bool process_units)=0;
		virtual void   MinVy(double* pminvy, bool process_units)=0;
		virtual void   MaxVy(double* pmaxvy, bool process_units)=0;
		virtual void   MaxAbsVy(double* pmaxabsvy, bool process_units)=0;
		virtual void   MinVz(double* pminvz, bool process_units)=0;
		virtual void   MaxVz(double* pmaxvz, bool process_units)=0;
		virtual void   MaxAbsVz(double* pmaxabsvz, bool process_units)=0;
		virtual void   ReinitializeInput(int reinitialized_enum,int original_enum)=0;


		/*Implementation: */

};
#endif
