/*!\file:  DakotaResponses.cpp
 * \brief  compute dakota responses, using a list of response descriptors.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../DataSet/DataSet.h"    
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../modules.h"

void DakotaResponses(double* responses,char** responses_descriptors,int numresponses,FemModel* femmodel){

	int i;
	int dummy;
	extern int my_rank;
	
	/*intermediary: */
	char* response_descriptor=NULL;
	double femmodel_response;
			

	for(i=0;i<numresponses;i++){

		response_descriptor=responses_descriptors[i];

		/*Compute response for this response_descriptor:*/

		if(strcmp(response_descriptor,"min_vel")==0){
			MinVelx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"max_vel")==0){
			MaxVelx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"min_vx")==0){
			MinVxx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"max_vx")==0){
			MaxVxx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"max_abs_vx")==0){
			MaxAbsVxx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"min_vy")==0){
			MinVyx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"max_vy")==0){
			MaxVyx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"max_abs_vy")==0){
			MaxAbsVyx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"min_vz")==0){
			MinVzx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"max_vz")==0){
			MaxVzx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"max_abs_vz")==0){
			MaxAbsVzx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"misfit")==0){
			Misfitx( &femmodel_response, femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters);
		}
		else if(strcmp(response_descriptor,"mass_flux")==0){

			double*   segments=NULL;
			int       num_segments;
			
			/*retrieve qmu_mass_flux_segments: */
			femmodel->parameters->FindParam(&segments,&num_segments,&dummy,QmuMassFluxSegmentsEnum);

			/*call mass flux module: */
			MassFluxx(&femmodel_response,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,segments,num_segments);

			/*Free ressources:*/
			xfree((void**)&segments);

		}
		else{
			ISSMERROR("%s%s%s"," response descriptor : ",response_descriptor," not supported yet!");
		}
			
		/*send response back to Dakota only on cpu 0: */
		if(my_rank==0)responses[i]=femmodel_response;
	}

}




