/*!\file RiftConstraints.h
 * \brief: manage penalties for rifts 
 */


#ifndef _RIFTCONSTRAINTS_H_
#define _RIFTCONSTRAINTS_H_

#include "../../objects/objects.h"
#include "../../DataSet/DataSet.h"

int RiftConstraints(int* pconverged, int* pnum_unstable_constraints,DataSet* loads,int min_mechanical_constraints);

int RiftIsPresent(DataSet* loads);

int IsPreStable(DataSet* loads);

int SetPreStable(DataSet* loads);

int PreConstrain(int* pnum_unstable_constraints,DataSet* loads);

int Constrain(int* pnum_unstable_constraints,DataSet* loads);

void FreezeConstraints(DataSet* loads);

int MaxPenetrationInInputs(DataSet* loads);

int PotentialUnstableConstraints(DataSet* loads);

int IsMaterialStable(DataSet* loads);

int IsFrozen(DataSet* loads);
#endif
