/*!\file MaxVyx
 */

#include "./MaxVyx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void MaxVyx( double* pmaxvy, DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials,Parameters* parameters){
	
	int i;
	double maxvy;
	double node_maxvy;
	bool   process_units=true;
	double element_maxvy;

	/*First, configure elements:*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxVy(&element_maxvy,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)maxvy=element_maxvy; //initialize maxvy
		else{
			if(element_maxvy>maxvy)maxvy=element_maxvy;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxvy=-INFINITY;
	}

	#ifdef _PARALLEL_
	/*Figure out minimum across the cluster: */
	MPI_Reduce (&maxvy,&node_maxvy,1,MPI_DOUBLE,MPI_MAX,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_maxvy,1,MPI_DOUBLE,0,MPI_COMM_WORLD);   
	maxvy=node_maxvy;
	#endif

	/*Assign output pointers:*/
	*pmaxvy=maxvy;
}
