/*!\file Gradjx
 * \brief: compute inverse method gradient
 */

#include "./Gradjx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void Gradjx( Vec* pgrad_g, int numberofnodes, DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,int control_type){

	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*output: */
	Vec grad_g=NULL;

	/*First, get elements and loads configured: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Allocate grad_g: */
	grad_g=NewVec(numberofnodes);

	/*Compute gradients: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->Gradj(grad_g,control_type);
	}

	/*Assemble vector: */
	VecAssemblyBegin(grad_g);
	VecAssemblyEnd(grad_g);

	/*Assign output pointers: */
	*pgrad_g=grad_g;
}
