/*!\file SingVertexResult.c
 * \brief: implementation of the SingVertexResult object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "./ResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION SingVertexResult::SingVertexResult(){{{1*/
SingVertexResult::SingVertexResult(){
	return;
}
/*}}}*/
/*FUNCTION SingVertexResult::SingVertexResult(int in_enum_type,double* in_values,int in_step, double in_time){{{1*/
SingVertexResult::SingVertexResult(int in_enum_type,double in_value,int in_step, double in_time):SingVertexInput(in_enum_type,in_value){

	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION SingVertexResult::~SingVertexResult(){{{1*/
SingVertexResult::~SingVertexResult(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION SingVertexResult::copy{{{1*/
Object* SingVertexResult::copy() {
	
	return new SingVertexResult(this->enum_type,this->value,this->step,this->time);

}
/*}}}*/
/*FUNCTION SingVertexResult::DeepEcho{{{1*/
void SingVertexResult::DeepEcho(void){
		
	printf("SingVertexResult:\n");
	SingVertexResult::DeepEcho();
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);

}
/*}}}*/
/*FUNCTION SingVertexResult::Demarshall{{{1*/
void  SingVertexResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION SingVertexResult::Echo {{{1*/
void SingVertexResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION SingVertexResult::Enum{{{1*/
int SingVertexResult::Enum(void){

	return SingVertexResultEnum;

}
/*}}}*/
/*FUNCTION SingVertexResult::EnumType{{{1*/
int SingVertexResult::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION SingVertexResult::Id{{{1*/
int    SingVertexResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION SingVertexResult::Marshall{{{1*/
void  SingVertexResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of SingVertexResult: */
	enum_value=SingVertexResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall SingVertexResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION SingVertexResult::MarshallSize{{{1*/
int   SingVertexResult::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION SingVertexResult::MyRank{{{1*/
int    SingVertexResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Result functions*/
/*FUNCTION SingVertexResult::ProcessUnits(Parameters* parameters){{{1*/
void SingVertexResult::ProcessUnits(Parameters* parameters){
	
	NodalValuesUnitConversion(&this->value,1,this->enum_type,parameters);

}
/*}}}*/
/*FUNCTION SingVertexResult::NumberOfNodalValues(void){{{1*/
int SingVertexResult::NumberOfNodalValues(void){
	return 1;
}
/*}}}*/
/*FUNCTION SingVertexResult::SingVertexResult::PatchFill(int row, Patch* patch){{{1*/
void SingVertexResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P0Enum,&this->value,1);

}
/*}}}*/
