/*!\file IntInput.c
 * \brief: implementation of the IntInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION IntInput::IntInput(){{{1*/
IntInput::IntInput(){
	return;
}
/*}}}*/
/*FUNCTION IntInput::IntInput(double* values){{{1*/
IntInput::IntInput(int in_enum_type,IssmInt in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION IntInput::~IntInput(){{{1*/
IntInput::~IntInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION IntInput::copy{{{1*/
Object* IntInput::copy() {
	
	return new IntInput(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION IntInput::DeepEcho{{{1*/
void IntInput::DeepEcho(void){

	printf("IntInput:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %i\n",this->value);
}
/*}}}*/
/*FUNCTION IntInput::Demarshall{{{1*/
void  IntInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION IntInput::Echo {{{1*/
void IntInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION IntInput::Enum{{{1*/
int IntInput::Enum(void){

	return IntInputEnum;

}
/*}}}*/
/*FUNCTION IntInput::EnumType{{{1*/
int IntInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION IntInput::Id{{{1*/
int    IntInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntInput::Marshall{{{1*/
void  IntInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of IntInput: */
	enum_value=IntInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall IntInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION IntInput::MarshallSize{{{1*/
int   IntInput::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION IntInput::MyRank{{{1*/
int    IntInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION IntInput::SpawnSingInput{{{1*/
Input* IntInput::SpawnSingInput(int index){

	/*output*/
	IntInput* outinput=new IntInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;
}
/*}}}*/
/*FUNCTION IntInput::SpawnBeamInput{{{1*/
Input* IntInput::SpawnBeamInput(int* indices){

	/*output*/
	IntInput* outinput=new IntInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;
}
/*}}}*/
/*FUNCTION IntInput::SpawnTriaInput{{{1*/
Input* IntInput::SpawnTriaInput(int* indices){

	/*output*/
	IntInput* outinput=new IntInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;
}
/*}}}*/
/*FUNCTION IntInput::SpawnResult{{{1*/
Result* IntInput::SpawnResult(int step, double time){
	
	ISSMERROR(" not supported yet!");

}
/*}}}*/

/*Object functions*/
/*FUNCTION IntInput::GetParameterValue(bool* pvalue) {{{1*/
void IntInput::GetParameterValue(bool* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetParameterValue(int* pvalue){{{1*/
void IntInput::GetParameterValue(int* pvalue){
	*pvalue=value;
}
/*}}}*/
/*FUNCTION IntInput::GetParameterValue(double* pvalue){{{1*/
void IntInput::GetParameterValue(double* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetParameterValue(double* pvalue,Node* node){{{1*/
void IntInput::GetParameterValue(double* pvalue,Node* node){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){{{1*/
void IntInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetParameterValue(double* pvalue,double* gauss){{{1*/
void IntInput::GetParameterValue(double* pvalue,double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){{{1*/
void IntInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){{{1*/
void IntInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){{{1*/
void IntInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::ChangeEnum(int newenumtype){{{1*/
void IntInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
/*FUNCTION IntInput::SquareMin(double* psquaremin, bool process_units){{{1*/
void IntInput::SquareMin(double* psquaremin, bool process_units,Parameters* parameters){

	/*square min of an integer is the square of the integer itself: */
	*psquaremin=pow(value,2);
}
/*}}}*/
