/*!\file: Sing.h
 * \brief prototypes for Sing element
 */ 

#ifndef _SING_H_
#define  _SING_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;

#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"

/*}}}*/

class Sing: public Element{

	public:

		/*ids:*/
		int id;

		Node* node; 
		Matice* matice;
		Matpar* matpar;
		
		Parameters* parameters; //pointer to solution parameters
		Inputs* inputs;


		/*constructors, destructors: {{{1*/
		Sing();
		~Sing();
		void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(DataSet* elements,DataSet* loads,DataSet* nodes,DataSet* materials,Parameters* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		bool  IsInput(int name);
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  SetClone(int* minranks);
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type);
		void  DepthAverageInputAtBase(int enum_type){ISSMERROR("not implemented yet");};
		void  InputToResult(int enum_type,int step,double time);
		void   ProcessResultsUnits(void);
		/*}}}*/
		/*numerics: {{{1*/
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg,  int analysis_type,int sub_analysis_type);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetSolutionFromInputs(Vec solution,  int analysis_type,int sub_analysis_type);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHutter(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  CreatePVectorDiagnosticHutter(Vec pg,int analysis_type,int sub_analysis_type);
		void* GetMatPar();
		void  ComputeBasalStress(Vec sigma_b,int analysis_type,int sub_analysis_type);
		void  ComputePressure(Vec p_g,int analysis_type,int sub_analysis_type);
		void  ComputeStrainRate(Vec eps,int analysis_type,int sub_analysis_type);
		void  GetNodes(void** vpnodes);
		void  PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void  PatchFill(int* pcount, Patch* patch);
		void  MinVel(double* pminvel, bool process_units);
		void  MaxVel(double* pmaxvel, bool process_units);

		/*}}}*/
		/*not implemented: {{{1*/
		bool   GetShelf();
		bool   GetOnBed();
		void  GetBedList(double*);
		void  GetThicknessList(double* thickness_list);
		void  Du(Vec,int,int);
		void  Gradj(Vec, int, int,int);
		void  GradjDrag(Vec , int,int);
		void  GradjB(Vec,  int,int);
		double Misfit(int,int);
		double SurfaceArea(int,int);
		double CostFunction(int,int);
		double MassFlux(double* segment,double* ug);
		/*}}}*/



};
#endif //ifndef _SING_H_

