/*!\file:  SpawnCore.cpp
 * \brief: branch into SpawnCoreMatlab and SpawnCoreParallel.
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#include "../../objects/objects.h"
#include "../../io/io.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "./Qmux.h"
#include "../../include/include.h"

int SpawnCore(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, void* femmodel,int counter){

	/*Branch into a serial SpawnCore and a parallel SpawnCore: */
	#ifdef _SERIAL_
	SpawnCoreSerial(responses, numresponses, variables, variables_descriptors,numvariables, (mxArray*)femmodel, counter);
	#else
	/*Call SpawnCoreParallel unless counter=-1 on cpu0, in which case, bail out and return 0: */
	MPI_Bcast(&counter,1,MPI_INT,0,MPI_COMM_WORLD); if(counter==-1)return 0;
	
	SpawnCoreParallel(responses, numresponses, variables, variables_descriptors,numvariables, (FemModel*)femmodel);
	#endif

	return 1;
}
