/*!\file TriaVertexResult.c
 * \brief: implementation of the TriaVertexResult object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "./ResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION TriaVertexResult::TriaVertexResult(){{{1*/
TriaVertexResult::TriaVertexResult(){
	return;
}
/*}}}*/
/*FUNCTION TriaVertexResult::TriaVertexResult(int in_enum_type,double* in_values,int in_step, double in_time){{{1*/
TriaVertexResult::TriaVertexResult(int in_enum_type,double* in_values,int in_step, double in_time):TriaVertexInput(in_enum_type,in_values){

	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION TriaVertexResult::~TriaVertexResult(){{{1*/
TriaVertexResult::~TriaVertexResult(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION TriaVertexResult::copy{{{1*/
Object* TriaVertexResult::copy() {
	
	return new TriaVertexResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/
/*FUNCTION TriaVertexResult::DeepEcho{{{1*/
void TriaVertexResult::DeepEcho(void){
		
	printf("TriaVertexResult:\n");
	TriaVertexResult::DeepEcho();
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);

}
/*}}}*/
/*FUNCTION TriaVertexResult::Demarshall{{{1*/
void  TriaVertexResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION TriaVertexResult::Echo {{{1*/
void TriaVertexResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION TriaVertexResult::Enum{{{1*/
int TriaVertexResult::Enum(void){

	return TriaVertexResultEnum;

}
/*}}}*/
/*FUNCTION TriaVertexResult::EnumType{{{1*/
int TriaVertexResult::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION TriaVertexResult::Id{{{1*/
int    TriaVertexResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION TriaVertexResult::Marshall{{{1*/
void  TriaVertexResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of TriaVertexResult: */
	enum_value=TriaVertexResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall TriaVertexResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION TriaVertexResult::MarshallSize{{{1*/
int   TriaVertexResult::MarshallSize(){
	
	return sizeof(values)+
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION TriaVertexResult::MyRank{{{1*/
int    TriaVertexResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Result functions*/
/*FUNCTION TriaVertexResult::SpawnSingResult{{{1*/
Result* TriaVertexResult::SpawnSingResult(int index){

	/*output*/
	SingVertexResult* outresult=NULL;

	/*Create new Sing result (copy of current result)*/
	ISSMASSERT(index<3 && index>=0);
	outresult=new SingVertexResult(this->enum_type,this->values[index],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION BeamVertexResult::SpawnBeamResult{{{1*/
Result* TriaVertexResult::SpawnBeamResult(int* indices){

	/*output*/
	BeamVertexResult* outresult=NULL;
	double newvalues[2];

	/*Loop over the new indices*/
	for(int i=0;i<2;i++){

		/*Check index value*/
		ISSMASSERT(indices[i]>=0 && indices[i]<3);

		/*Assign value to new result*/
		newvalues[i]=this->values[indices[i]];
	}

	/*Create new Beam result*/
	outresult=new BeamVertexResult(this->enum_type,&newvalues[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION TriaVertexResult::SpawnTriaResult{{{1*/
Result* TriaVertexResult::SpawnTriaResult(int* indices){

	/*output*/
	TriaVertexResult* outresult=NULL;

	/*Create new Tria result (copy of current result)*/
	outresult=new TriaVertexResult(this->enum_type,&this->values[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION TriaVertexResult::ProcessUnits(Parameters* parameters){{{1*/
Result* TriaVertexResult::ProcessUnits(Parameters* parameters){
	
	NodalValuesUnitConversion(this->values,3,this->enum_type,parameters);

}
/*}}}*/
/*FUNCTION TriaVertexResult::NumberOfNodalValues(void){{{1*/
int TriaVertexResult::NumberOfNodalValues(void){
	return 3;
}
/*}}}*/
/*FUNCTION TriaVertexResult::TriaVertexResult::PatchFill(int row, Patch* patch){{{1*/
void TriaVertexResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,3);

}
/*}}}*/
