/*! \file PentaVertexResult.h 
 *  \brief: header file for penta vertex result  object. 
 *  this object is just a PentaVertexInput with additional time and step info.
 */


#ifndef _PENTAVERTEXRESULT_H_
#define _PENTAVERTEXRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class PentaVertexResult: public PentaVertexInput,public Result{

	private: 
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		PentaVertexResult();
		PentaVertexResult(int enum_type,double* values,int step, double time);
		~PentaVertexResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*result virtual functions: {{{1*/
		Result* SpawnSingResult(int  index);
		Result* SpawnBeamResult(int* indices);
		Result* SpawnTriaResult(int* indices);
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/

};
#endif  /* _PENTAVERTEXRESULT_H */
