/*!\file PentaVertexResult.c
 * \brief: implementation of the PentaVertexResult object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "./ResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION PentaVertexResult::PentaVertexResult(){{{1*/
PentaVertexResult::PentaVertexResult(){
	return;
}
/*}}}*/
/*FUNCTION PentaVertexResult::PentaVertexResult(int in_enum_type,double* in_values,int in_step, double in_time){{{1*/
PentaVertexResult::PentaVertexResult(int in_enum_type,double* in_values,int in_step, double in_time): PentaVertexInput(in_enum_type,in_values){

	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION PentaVertexResult::~PentaVertexResult(){{{1*/
PentaVertexResult::~PentaVertexResult(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION PentaVertexResult::copy{{{1*/
Object* PentaVertexResult::copy() {
	
	return new PentaVertexResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/
/*FUNCTION PentaVertexResult::DeepEcho{{{1*/
void PentaVertexResult::DeepEcho(void){

	printf("PentaVertexResult:\n");
	PentaVertexResult::DeepEcho();
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);

}
/*}}}*/
/*FUNCTION PentaVertexResult::Demarshall{{{1*/
void  PentaVertexResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION PentaVertexResult::Echo {{{1*/
void PentaVertexResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION PentaVertexResult::Enum{{{1*/
int PentaVertexResult::Enum(void){

	return PentaVertexResultEnum;

}
/*}}}*/
/*FUNCTION PentaVertexResult::EnumType{{{1*/
int PentaVertexResult::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION PentaVertexResult::Id{{{1*/
int    PentaVertexResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION PentaVertexResult::Marshall{{{1*/
void  PentaVertexResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of PentaVertexResult: */
	enum_value=PentaVertexResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall PentaVertexResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION PentaVertexResult::MarshallSize{{{1*/
int   PentaVertexResult::MarshallSize(){
	
	return sizeof(values)+
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION PentaVertexResult::MyRank{{{1*/
int    PentaVertexResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Result functions*/
/*FUNCTION PentaVertexResult::SpawnSingResult{{{1*/
Result* PentaVertexResult::SpawnSingResult(int index){

	/*output*/
	SingVertexResult* outresult=NULL;

	/*Create new Sing result (copy of current result)*/
	ISSMASSERT(index<6 && index>=0);
	outresult=new SingVertexResult(this->enum_type,this->values[index],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION PentaVertexResult::SpawnBeamResult{{{1*/
Result* PentaVertexResult::SpawnBeamResult(int* indices){

	/*output*/
	BeamVertexResult* outresult=NULL;
	double newvalues[2];

	/*Loop over the new indices*/
	for(int i=0;i<2;i++){

		/*Check index value*/
		ISSMASSERT(indices[i]>=0 && indices[i]<6);

		/*Assign value to new result*/
		newvalues[i]=this->values[indices[i]];
	}

	/*Create new Beam result*/
	outresult=new BeamVertexResult(this->enum_type,&newvalues[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION PentaVertexResult::SpawnTriaResult{{{1*/
Result* PentaVertexResult::SpawnTriaResult(int* indices){

	/*output*/
	TriaVertexResult* outresult=NULL;
	double newvalues[3];

	/*Loop over the new indices*/
	for(int i=0;i<3;i++){

		/*Check index value*/
		ISSMASSERT(indices[i]>=0 && indices[i]<6);

		/*Assign value to new result*/
		newvalues[i]=this->values[indices[i]];
	}

	/*Create new Tria result*/
	outresult=new TriaVertexResult(this->enum_type,&newvalues[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION PentaVertexResult::ProcessUnits(Parameters* parameters){{{1*/
Result* PentaVertexResult::ProcessUnits(Parameters* parameters){
	
	NodalValuesUnitConversion(this->values,6,this->enum_type,parameters);

}
/*}}}*/
/*FUNCTION PentaVertexResult::NumberOfNodalValues(void){{{1*/
int PentaVertexResult::NumberOfNodalValues(void){
	return 6;
}
/*}}}*/
/*FUNCTION PentaVertexResult::PentaVertexResult::PatchFill(int row, Patch* patch){{{1*/
void PentaVertexResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,6);

}
/*}}}*/
