/*!\file:  NodalValuesUnitConversion.cpp
 * \brief: process nodal_values held in a Result object.
 * For example, velocities need to be in m/yr, melting rates in m/yr, etc ...
 * This centralizes all post-processing of results when they are being output.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../DataSet/DataSet.h"
#include "../../objects/objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"

void NodalValuesUnitConversion(double* nodal_values, int num_nodal_values,int enum_type,Parameters* parameters){

	int i;
	double yts;

	/*Gete some values from parameters, that are often needed: */
	parameters->FindParam(&yts,YtsEnum);

	switch(enum_type){
		case VxEnum: for(i=0;i<num_nodal_values;i++)nodal_values[i]=nodal_values[i]/yts;break;
		case VyEnum: for(i=0;i<num_nodal_values;i++)nodal_values[i]=nodal_values[i]/yts;break;
		case VzEnum: for(i=0;i<num_nodal_values;i++)nodal_values[i]=nodal_values[i]/yts;break;
		case MeltingRateEnum: for(i=0;i<num_nodal_values;i++)nodal_values[i]=nodal_values[i]/yts;break;
		default: break;
	}
}
