/*!\file DoubleResult.c
 * \brief: implementation of the DoubleResult object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "./ResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION DoubleResult::DoubleResult(){{{1*/
DoubleResult::DoubleResult(){
	return;
}
/*}}}*/
/*FUNCTION DoubleResult::DoubleResult(int in_enum_type,IssmDouble in_value,int in_step, double in_time){{{1*/
DoubleResult::DoubleResult(int in_enum_type,IssmDouble in_value,int in_step, double in_time): DoubleInput(in_enum_type,in_value){
		
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION DoubleResult::~DoubleResult(){{{1*/
DoubleResult::~DoubleResult(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION DoubleResult::copy{{{1*/
Object* DoubleResult::copy() {

	DoubleResult* result=new DoubleResult(this->enum_type,this->value,this->step,this->time);
	return (Object*)result;
	//return new DoubleResult(this->enum_type,this->value,this->step,this->time);

}
/*}}}*/
/*FUNCTION DoubleResult::DeepEcho{{{1*/
void DoubleResult::DeepEcho(void){

	printf("DoubleResult:\n");
	DoubleInput::DeepEcho();
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION DoubleResult::Demarshall{{{1*/
void  DoubleResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DoubleResult::Echo {{{1*/
void DoubleResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleResult::Enum{{{1*/
int DoubleResult::Enum(void){

	return DoubleResultEnum;

}
/*}}}*/
/*FUNCTION DoubleResult::EnumType{{{1*/
int DoubleResult::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION DoubleResult::Id{{{1*/
int    DoubleResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleResult::Marshall{{{1*/
void  DoubleResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleResult: */
	enum_value=DoubleResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleResult::MarshallSize{{{1*/
int   DoubleResult::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleResult::MyRank{{{1*/
int    DoubleResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Result functions*/
/*FUNCTION DoubleResult::SpawnSingResult{{{1*/
Result* DoubleResult::SpawnSingResult(int index){

	/*output*/
	DoubleResult* outresult=new DoubleResult();

	/*copy fields: */
	outresult->enum_type=this->enum_type;
	outresult->value=this->value;
	outresult->time=this->time;
	outresult->step=this->step;

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION DoubleResult::SpawnBeamResult{{{1*/
Result* DoubleResult::SpawnBeamResult(int* indices){

	/*output*/
	DoubleResult* outresult=new DoubleResult();

	/*copy fields: */
	outresult->enum_type=this->enum_type;
	outresult->value=this->value;
	outresult->time=this->time;
	outresult->step=this->step;


	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION DoubleResult::SpawnTriaResult{{{1*/
Result* DoubleResult::SpawnTriaResult(int* indices){

	/*output*/
	DoubleResult* outresult=new DoubleResult();

	/*copy fields: */
	outresult->enum_type=this->enum_type;
	outresult->value=this->value;
	outresult->time=this->time;
	outresult->step=this->step;

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION DoubleResult::ProcessUnits(Parameters* parameters){{{1*/
void DoubleResult::ProcessUnits(Parameters* parameters){
	
	NodalValuesUnitConversion(&this->value,1,this->enum_type,parameters);

}
/*}}}*/
/*FUNCTION DoubleResult::NumberOfNodalValues(void){{{1*/
int DoubleResult::NumberOfNodalValues(void){
	return 1;
}
/*}}}*/
/*FUNCTION DoubleResult::DoubleResult::PatchFill(int row, Patch* patch){{{1*/
void DoubleResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P0Enum,&this->value,1);

}
/*}}}*/
