/*! \file BeamVertexResult.h 
 *  \brief: header file for triavertexresult object
 */


#ifndef _BEAMVERTEXRESULT_H_
#define _BEAMVERTEXRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class BeamVertexResult: public BeamVertexInput,public Result{

	private: 
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		BeamVertexResult();
		BeamVertexResult(int enum_type,double* values,int step,double time);
		~BeamVertexResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*result virtual functions: {{{1*/
		Result* SpawnSingResult(int  index){ISSMERROR("Not implemented yet!");}
		Result* SpawnBeamResult(int* indices){ISSMERROR("Not implemented yet!");}
		Result* SpawnTriaResult(int* indices){ISSMERROR("Not implemented yet!");}
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/

};
#endif  /* _BEAMVERTEXRESULT_H */
