/*!\file BeamVertexResult.c
 * \brief: implementation of the BeamVertexResult object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "./ResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION BeamVertexResult::BeamVertexResult(){{{1*/
BeamVertexResult::BeamVertexResult(){
	return;
}
/*}}}*/
/*FUNCTION BeamVertexResult::BeamVertexResult(int in_enum_type,double* in_values,int in_step, double in_time){{{1*/
BeamVertexResult::BeamVertexResult(int in_enum_type,double* in_values,int in_step, double in_time):BeamVertexInput(in_enum_type,in_values){

	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION BeamVertexResult::~BeamVertexResult(){{{1*/
BeamVertexResult::~BeamVertexResult(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION BeamVertexResult::copy{{{1*/
Object* BeamVertexResult::copy() {
	
	return new BeamVertexResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/
/*FUNCTION BeamVertexResult::DeepEcho{{{1*/
void BeamVertexResult::DeepEcho(void){
		
	printf("BeamVertexResult:\n");
	BeamVertexResult::DeepEcho();
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);

}
/*}}}*/
/*FUNCTION BeamVertexResult::Demarshall{{{1*/
void  BeamVertexResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION BeamVertexResult::Echo {{{1*/
void BeamVertexResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BeamVertexResult::Enum{{{1*/
int BeamVertexResult::Enum(void){

	return BeamVertexResultEnum;

}
/*}}}*/
/*FUNCTION BeamVertexResult::EnumType{{{1*/
int BeamVertexResult::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION BeamVertexResult::Id{{{1*/
int    BeamVertexResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BeamVertexResult::Marshall{{{1*/
void  BeamVertexResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of BeamVertexResult: */
	enum_value=BeamVertexResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall BeamVertexResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION BeamVertexResult::MarshallSize{{{1*/
int   BeamVertexResult::MarshallSize(){
	
	return sizeof(values)+
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION BeamVertexResult::MyRank{{{1*/
int    BeamVertexResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Result functions*/
/*FUNCTION BeamVertexResult::ProcessUnits(Parameters* parameters){{{1*/
Result* BeamVertexResult::ProcessUnits(Parameters* parameters){
	
	NodalValuesUnitConversion(this->values,2,this->enum_type,parameters);

}
/*}}}*/
/*FUNCTION BeamVertexResult::NumberOfNodalValues(void){{{1*/
int BeamVertexResult::NumberOfNodalValues(void){
	return 2;
}
/*}}}*/
/*FUNCTION BeamVertexResult::BeamVertexResult::PatchFill(int row, Patch* patch){{{1*/
void BeamVertexResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,2);

}
/*}}}*/
