/*!\file Sing.c
 * \brief: implementation of the Sing object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION Sing::Sing(){{{1*/
Sing::Sing(){
	this->inputs=NULL;
	this->parameters=NULL;
	return;
}
/*}}}*/
/*FUNCTION Sing::~Sing(){{{1*/
Sing::~Sing(){
	delete inputs;
	this->parameters=NULL;
}
/*}}}*/
/*FUNCTION void Sing::Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);{{{1*/
void Sing::Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type){
	ISSMERROR(" not supported yet!");
}
/*}}}*/

/*Object management*/
/*FUNCTION Sing::Configure {{{1*/
void  Sing::Configure(DataSet* elementsin,DataSet* loadsin, DataSet* nodesin, DataSet* materialsin, Parameters* parametersin){

	ISSMERROR(" not supported yet!");

}
/*}}}*/
/*FUNCTION Sing::copy {{{1*/
Object* Sing::copy() {

	int i;
	Sing* sing=NULL;

	sing=new Sing();

	/*copy fields: */
	sing->id=this->id;
	if(this->inputs){
		sing->inputs=(Inputs*)this->inputs->Copy();
	}
	else{
		sing->inputs=new Inputs();
	}
	/*point parameters: */
	sing->parameters=this->parameters;

	/*pointers: */
	sing->node=this->node;
	sing->matice=this->matice;
	sing->matpar=this->matpar;

	return sing;
}
/*}}}*/
/*FUNCTION Sing::DeepEcho {{{1*/
void Sing::DeepEcho(void){

	printf("Sing:\n");
	printf("   id: %i\n",id);
	node->DeepEcho();
	matice->DeepEcho();
	matpar->DeepEcho();
	printf("   parameters\n");
	parameters->DeepEcho();
	printf("   inputs\n");
	inputs->DeepEcho();

	return;
}
/*}}}*/
/*FUNCTION Sing::Demarshall {{{1*/
void  Sing::Demarshall(char** pmarshalled_dataset){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::Echo{{{1*/

void Sing::Echo(void){

	printf("Sing:\n");
	printf("   id: %i\n",id);
	node->Echo();
	matice->Echo();
	matpar->Echo();
	printf("   parameters\n");
	parameters->Echo();
	printf("   inputs\n");
	inputs->Echo();
}
/*}}}*/
/*FUNCTION Sing::IsInput{{{1*/
bool Sing::IsInput(int name){
	if (name==SurfaceSlopeXEnum ||
				name==SurfaceSlopeYEnum){
		return true;
	}
	else return false;
}
/*}}}*/
/*FUNCTION Sing::Marshall {{{1*/
void  Sing::Marshall(char** pmarshalled_dataset){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::MashallSize {{{1*/
int   Sing::MarshallSize(){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::UpdateInputsFromSolution {{{1*/
void  Sing::UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GetSolutionFromInputs(Vec solution,  int analysis_type,int sub_analysis_type);{{{1*/
void  Sing::GetSolutionFromInputs(Vec solution,  int analysis_type,int sub_analysis_type){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::InputToResult(int enum_type,int step,double time){{{1*/
void  Sing::InputToResult(int enum_type,int step,double time){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::ProcessResultsUnits(void){{{1*/
void  Sing::ProcessResultsUnits(void){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
		
/*Object functions*/
/*FUNCTION Sing::ComputeBasalStress {{{1*/
void  Sing::ComputeBasalStress(Vec p_g,int analysis_type,int sub_analysis_type){

	ISSMERROR("Not implemented yet");

}
/*}}}*/
/*FUNCTION Sing::ComputePressure {{{1*/
void  Sing::ComputePressure(Vec p_g,int analysis_type,int sub_analysis_type){

	int    dof;
	double pressure;
	double thickness;
	double rho_ice,g;

	/*Get dof list on which we will plug the pressure values: */
	GetDofList1(&dof);

	/*pressure is lithostatic: */
	rho_ice=matpar->GetRhoIce();
	g=matpar->GetG();
	inputs->GetParameterValue(&thickness,ThicknessEnum);
	pressure=rho_ice*g*thickness;
	
	/*plug local pressure values into global pressure vector: */
	VecSetValue(p_g,dof,pressure,INSERT_VALUES);

}
/*}}}*/
/*FUNCTION Sing::ComputeStrainRate {{{1*/
void  Sing::ComputeStrainRate(Vec p_g,int analysis_type,int sub_analysis_type){

	ISSMERROR("Not implemented yet");

}
/*}}}*/
/*FUNCTION Sing::CostFunction {{{1*/
double Sing::CostFunction( int,int){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::CreateKMatrix {{{1*/

void  Sing::CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type){

	/*Just branch to the correct element stiffness matrix generator, according to the type of analysis we are carrying out: */
	if ((analysis_type==DiagnosticAnalysisEnum) && (sub_analysis_type==HutterAnalysisEnum)){

		CreateKMatrixDiagnosticHutter( Kgg,analysis_type,sub_analysis_type);

	}
	else{
		ISSMERROR("%s%i%s%i%s\n","analysis: ",analysis_type," and sub_analysis_type: ",sub_analysis_type," not supported yet");
	}

}
/*}}}*/
/*FUNCTION Sing::CreateKMatrixDiagnosticHutter {{{1*/
void  Sing::CreateKMatrixDiagnosticHutter(Mat Kgg,int analysis_type,int sub_analysis_type){
	
	const int numgrids=1;
	const int NDOF2=2;
	const int numdofs=numgrids*NDOF2;
	double Ke_gg[numdofs][numdofs]={{1,0},{0,1}};
	int    doflist[numdofs];
	int    numberofdofspernode;
	int    connectivity;

	/*Find connectivity of the node and divide Ke_gg by this connectivity*/
	connectivity=node->GetConnectivity();
	Ke_gg[0][0]=1/(double)connectivity;
	Ke_gg[1][1]=1/(double)connectivity;

	GetDofList(&doflist[0],&numberofdofspernode);

	MatSetValues(Kgg,numdofs,doflist,numdofs,doflist,(const double*)Ke_gg,ADD_VALUES);

}
/*}}}*/
/*FUNCTION Sing::CreatePVector {{{1*/
void  Sing::CreatePVector(Vec pg,int analysis_type,int sub_analysis_type){
	
	/*Just branch to the correct load generator, according to the type of analysis we are carrying out: */
	if ((analysis_type==DiagnosticAnalysisEnum) && (sub_analysis_type==HutterAnalysisEnum)){
	
			CreatePVectorDiagnosticHutter( pg,analysis_type,sub_analysis_type);

	}
	else{
		ISSMERROR("%s%i%s"," analysis ",analysis_type," not supported yet");
	}

}
/*}}}*/
/*FUNCTION Sing::CreatePVectorDiagnosticHutter {{{1*/
void Sing::CreatePVectorDiagnosticHutter( Vec pg,  int analysis_type,int sub_analysis_type){
	
	const int numgrids=1;
	const int NDOF2=2;
	const int numdofs=NDOF2*numgrids;
	int       doflist[numdofs];
	int       dofs[1]={0};
	int       found=0;
	double    slope[2];
	double    slope2;
	double    pe_g[numdofs]={0,0};
	double    ub,vb;
	double    constant_part;
	int       numberofdofspernode;
	double    rho_ice,gravity,n,B;
	double    thickness;
	int       connectivity;

	inputs->GetParameterValue(&slope[0],SurfaceSlopeXEnum);
	inputs->GetParameterValue(&slope[1],SurfaceSlopeYEnum);

	GetDofList(&doflist[0],&numberofdofspernode);

	//Get connectivity of the node
	connectivity=node->GetConnectivity();

	//compute slope2 
	slope2=pow(slope[0],2)+pow(slope[1],2);

	//compute ub
	rho_ice=matpar->GetRhoIce();
	gravity=matpar->GetG();
	n=matice->GetN();
	B=matice->GetB();
	inputs->GetParameterValue(&thickness,ThicknessEnum);

	ub=-1.58*pow((double)10.0,(double)-10.0)*rho_ice*gravity*thickness*slope[0];
	vb=-1.58*pow((double)10.0,(double)-10.0)*rho_ice*gravity*thickness*slope[1];

	//compute constant_part
	constant_part=-2*pow(rho_ice*gravity,n)*pow(slope2,((n-1)/2));

	pe_g[0]=(ub-2.0*pow(rho_ice*gravity,n)*pow(slope2,((n-1)/2.0))*pow(thickness,n)/(pow(B,n)*(n+1))*slope[0])/(double)connectivity;
	pe_g[1]=(vb-2.0*pow(rho_ice*gravity,n)*pow(slope2,((n-1)/2.0))*pow(thickness,n)/(pow(B,n)*(n+1))*slope[1])/(double)connectivity;

	VecSetValues(pg,numdofs,doflist,(const double*)pe_g,ADD_VALUES);

}
/*}}}*/
/*FUNCTION Sing::Du {{{1*/
void  Sing::Du(Vec,int,int){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::Enum {{{1*/
int Sing::Enum(void){

	return SingEnum;

}
/*}}}*/
/*FUNCTION Sing::GetBedList {{{1*/
void  Sing::GetBedList(double*){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GetDofList {{{1*/
void  Sing::GetDofList(int* doflist,int* pnumberofdofspernode){

	int i;
	int doflist_per_node[MAXDOFSPERNODE];
	int numberofdofspernode;
	
	node->GetDofList(&doflist_per_node[0],&numberofdofspernode);
	for(i=0;i<numberofdofspernode;i++){
		doflist[i]=doflist_per_node[i];
	}

	/*Assign output pointers:*/
	*pnumberofdofspernode=numberofdofspernode;

}
/*}}}*/
/*FUNCTION Sing::GetDofList1 {{{1*/
void  Sing::GetDofList1(int* doflist){

	int i;
	doflist[0]=node->GetDofList1();

}
/*}}}*/
/*FUNCTION Sing::Id {{{1*/
int    Sing::Id(void){ return id; }
/*}}}*/
/*FUNCTION Sing::GetMatPar {{{1*/
void* Sing::GetMatPar(){

	return matpar;
}
/*}}}*/
/*FUNCTION Sing::GetNodes {{{1*/
void  Sing::GetNodes(void** vpnodes){
	
	Node** pnodes=NULL;

	/*recover nodes: */
	pnodes=(Node**)vpnodes;

	pnodes[0]=node;
}
/*}}}*/
/*FUNCTION Sing::GetOnBed {{{1*/
bool   Sing::GetOnBed(){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GetShelf {{{1*/
bool   Sing::GetShelf(){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GetThicknessList {{{1*/
void  Sing::GetThicknessList(double* thickness_list){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::Gradj {{{1*/
void  Sing::Gradj(Vec,  int, int ,int){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GradB {{{1*/
void  Sing::GradjB(Vec,  int,int){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GradjDrag {{{1*/
void  Sing::GradjDrag(Vec,  int,int){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::MassFlux {{{1*/
double Sing::MassFlux( double* segment,double* ug){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::Misfit {{{1*/
double Sing::Misfit( int,int){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::MyRank {{{1*/
int    Sing::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION Sing::SurfaceArea {{{1*/
double Sing::SurfaceArea( int,int){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::SetClone {{{1*/
void  Sing::SetClone(int* minranks){

	ISSMERROR("not implemented yet");
}
/*}}}1*/
/*FUNCTION Sing::UpdateInputsFromVector(double* vector, int name, int type);{{{1*/
void  Sing::UpdateInputsFromVector(double* vector, int name, int type){

	/*Check that name is an element input*/
	if (!IsInput(name)) return;

	switch(type){

		case VertexEnum:

			/*New SingVertexInpu*/
			double value;

			/*Get values on the 6 vertices*/
			value=vector[node->GetVertexDof()];

			/*update input*/
			this->inputs->AddInput(new SingVertexInput(name,value));
			return;

		default:
			ISSMERROR("type %i (%s) not implemented yet",type,EnumAsString(type));
	}
}
/*}}}*/
/*FUNCTION Sing::UpdateInputsFromVector(int* vector, int name, int type);{{{1*/
void  Sing::UpdateInputsFromVector(int* vector, int name, int type){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::UpdateInputsFromVector(bool* vector, int name, int type);{{{1*/
void  Sing::UpdateInputsFromVector(bool* vector, int name, int type){
	ISSMERROR(" not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes){{{1*/
void  Sing::PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes){

	int     i;
	
	/*output: */
	int     numrows     = 0;
	int     numvertices = 0;
	int     numnodes    = 0;

	/*Go through all the results objects, and update the counters: */
	for (i=0;i<this->results->Size();i++){
		Result* result=(Result*)this->results->GetObjectByOffset(i);
		/*first, we have one more result: */
		numrows++;
		/*now, how many vertices and how many nodal values for this result? :*/
		numvertices=1; //this is a sing element, with 1 vertex
		numnodes=result->NumberOfNodalValues(); //ask result object.
	}

	/*Assign output pointers:*/
	*pnumrows=numrows;
	*pnumvertices=numvertices;
	*pnumnodes=numnodes;
	
}
/*}}}*/
/*FUNCTION Sing::PatchFill(int* pcount, Patch* patch){{{1*/
void  Sing::PatchFill(int* pcount, Patch* patch){

	int i;
	int count;
	int vertices_ids[1];


	/*recover pointer: */
	count=*pcount;
		
	/*will be needed later: */
	for(i=0;i<1;i++) vertices_ids[i]=nodes[i]->GetVertexId(); //vertices id start at column 3 of the patch.

	for(i=0;i<this->results->Size();i++){
		Result* result=(Result*)this->results->GetObjectByOffset(i);

		/*For this result,fill the information in the Patch object (element id + vertices ids), and then hand 
		 *it to the result object, to fill the rest: */
		patch->fillelementinfo(count,this->id,vertices_ids,1);
		result->PatchFill(count,patch);

		/*increment counter: */
		count++;
	}

	/*Assign output pointers:*/
	*pcount=count;
}
