/*! \file TriaVertexResult.h 
 *  \brief: header file for triavertexresult object
 */


#ifndef _TRIAVERTEXRESULT_H_
#define _TRIAVERTEXRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class TriaVertexResult: public TriaVertexInput,public Result{

	private: 
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		TriaVertexResult();
		TriaVertexResult(int enum_type,double* values,int step,double time);
		~TriaVertexResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		/*}}}*/
		/*result virtual functions: {{{1*/
		Result* SpawnSingResult(int  index);
		Result* SpawnBeamResult(int* indices);
		Result* SpawnTriaResult(int* indices);
		/*}}}*/

};
#endif  /* _TRIAVERTEXRESULT_H */
