/*! \file PentaVertexResult.h 
 *  \brief: header file for penta vertex result  object. 
 *  this object is just a PentaVertexInput with additional time and step info.
 */


#ifndef _PENTAVERTEXRESULT_H_
#define _PENTAVERTEXRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class PentaVertexResult: public PentaVertexInput,public Result{

	private: 
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		PentaVertexResult();
		PentaVertexResult(int enum_type,double* values,int step, double time);
		~PentaVertexResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		/*}}}*/
		/*result virtual functions: {{{1*/
		Result* SpawnSingResult(int  index);
		Result* SpawnBeamResult(int* indices);
		Result* SpawnTriaResult(int* indices);
		/*}}}*/

};
#endif  /* _PENTAVERTEXRESULT_H */
