/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 


#ifndef _ELEMENT_H_
#define _ELEMENT_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"

class DataSet;
class Parameters;

#include "../../toolkits/toolkits.h"
/*}}}*/

class Element: public Object{

	public: 
		
		virtual        ~Element(){};
		virtual void   Configure(DataSet* elements,DataSet* loads,DataSet* nodes,DataSet* materials,Parameters* parameters)=0;
		
		virtual void   CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type)=0;
		virtual void   CreatePVector(Vec pg,  int analysis_type,int sub_analysis_type)=0;
		virtual void   GetSolutionFromInputs(Vec solution,  int analysis_type,int sub_analysis_type)=0;
		virtual void   GetNodes(void** nodes)=0;
		virtual void*  GetMatPar()=0;
		virtual bool   GetShelf()=0; 
		virtual bool   GetOnBed()=0;
		virtual void   GetThicknessList(double* thickness_list)=0;
		virtual void   GetBedList(double* bed_list)=0;
		virtual void   Du(Vec du_g,int analysis_type,int sub_analysis_type)=0;
		virtual void   Gradj(Vec grad_g,int analysis_type,int sub_analysis_type,int control_type)=0;
		virtual void   GradjDrag(Vec grad_g,int analysis_type,int sub_analysis_type)=0;
		virtual void   GradjB(Vec grad_g,int analysis_type,int sub_analysis_type)=0;
		virtual double Misfit(int analysis_type,int sub_analysis_type)=0;
		virtual double CostFunction(int analysis_type,int sub_analysis_type)=0;
		virtual double SurfaceArea(int analysis_type,int sub_analysis_type)=0;
		virtual void   DepthAverageInputAtBase(int enum_type)=0;
		virtual void   ComputeBasalStress(Vec sigma_b,int analysis_type,int sub_analysis_type)=0;
		virtual void   ComputePressure(Vec p_g,       int analysis_type,int sub_analysis_type)=0;
		virtual void   ComputeStrainRate(Vec eps,     int analysis_type,int sub_analysis_type)=0;
		virtual double MassFlux(double* segment,double* ug)=0;
		virtual void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes,int enum_type)=0;
		virtual void   PatchFill(int* pcount, double* patches,int numcols,int max_vertices,int enum_type)=0;
		virtual void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type)=0;
		virtual void   InputToResult(int enum_type,int step,double time);

		/*Implementation: */

};
#endif
