/*!\file UpdateInputsFromSolutionx
 * \brief: update datasets using  parameter inputs
 */

#include "./UpdateInputsFromSolutionx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void UpdateInputsFromSolutionx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,Vec solution, int analysis_type, int sub_analysis_type,int step=0){

	double* serial_solution=NULL;

	/*Serialize solution, so that elements can index into it on every CPU: */
	VecToMPISerial(&serial_solution,solution);

	/*Call overloaded form of UpdateInputsFromSolutionx: */
	UpdateInputsFromSolutionx( elements, nodes,  vertices,  loads,  materials,  parameters,serial_solution, analysis_type, sub_analysis_type,step);

	/*Free ressources:*/
	xfree((void**)&serial_solution);

}


void UpdateInputsFromSolutionx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,double* solution, int analysis_type, int sub_analysis_type){

	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*First, get elements and loads configured: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);
	
	/*Elements drive the update: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->UpdateInputsFromSolution(solution,analysis_type,sub_analysis_type);
	}

}

/*Same routines, with additional timestep argument: */
void UpdateInputsFromSolutionx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,Vec solution, int analysis_type, int sub_analysis_type,int timestep){
	
	
	double* serial_solution=NULL;

	/*Serialize solution, so that elements can index into it on every CPU: */
	VecToMPISerial(&serial_solution,solution);

	/*Call overloaded form of UpdateInputsFromSolutionx: */
	UpdateInputsFromSolutionx( elements, nodes,  vertices,  loads,  materials,  parameters,serial_solution, analysis_type, sub_analysis_type,int timestep);

	/*Free ressources:*/
	xfree((void**)&serial_solution);

}



void UpdateInputsFromSolutionx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,double* solution, int analysis_type, int sub_analysis_type,int timestep){

	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*First, get elements and loads configured: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);
	
	/*Elements drive the update: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->UpdateInputsFromSolution(solution,analysis_type,sub_analysis_type,timestep);
	}

}
