/*!\file:  InputsToPatches.cpp
 * \brief  fill patches from inputs
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "InputsToPatches"

#include "./InputToResultx.h"
#include "../../DataSet/DataSet.h"

void InputToPatches(DataSet* elements,double* patches,int patch_numcols,int max_vertices,int enum_type){

	int i;

	/*intermediary:*/
	Element* element=NULL;
	int count=0;

	/*Go through elemnets, and each time an element holds an input with the correct enum_type, increase count by 1, and fill the 
	 * patches matrix with the input data: */
	 
	for(i=0;i<elements->Size();i++){

		element=(Element*)elements->GetObjectByOffset(i);
		element->PatchFill(&count,patches,patch_numcols,max_vertices,enum_type);

	}

}
