/*
 * \file Results.c
 * \brief: implementation of the Results class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Results::Results(){{{1*/
Results::Results(){
	return;
}
/*}}}*/
/*FUNCTION Results::Results(int in_enum){{{1*/
Results::Results(int in_enum): DataSet(in_enum) {
	//do nothing;
	return;
}
/*}}}*/
/*FUNCTION Results::~Results(){{{1*/
Results::~Results(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION Results::SpawnBeamResults{{{1*/
Results* Results::SpawnBeamResults(int* indices){

	/*Intermediary*/
	vector<Object*>::iterator object;
	Result* resultin=NULL;
	Result* resultout=NULL;

	/*Output*/
	Results* newresults=new Results();

	/*Go through results and call Spawn function*/
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Create new result*/
		resultin=(Result*)(*object); 
		resultout=resultin->SpawnBeamResult(indices);

		/*Add result to new results*/
		newresults->AddObject(resultout);
	}

	/*Assign output pointer*/
	return newresults;
}
/*}}}*/
/*FUNCTION Results::SpawnSingResults{{{1*/
Results* Results::SpawnSingResults(int index){

	/*Intermediary*/
	vector<Object*>::iterator object;
	Result* resultin=NULL;
	Result* resultout=NULL;

	/*Output*/
	Results* newresults=new Results();

	/*Go through results and call Spawn function*/
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Create new result*/
		resultin=(Result*)(*object); 
		resultout=resultin->SpawnSingResult(index);

		/*Add result to new results*/
		newresults->AddObject(resultout);
	}

	/*Assign output pointer*/
	return newresults;
}
/*}}}*/
/*FUNCTION Results::SpawnTriaResults{{{1*/
Results* Results::SpawnTriaResults(int* indices){

	/*Intermediary*/
	vector<Object*>::iterator object;
	Result* resultin=NULL;
	Result* resultout=NULL;

	/*Output*/
	Results* newresults=new Results();

	/*Go through results and call Spawn function*/
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Create new result*/
		resultin=(Result*)(*object); 
		resultout=resultin->SpawnTriaResult(indices);

		/*Add result to new results*/
		newresults->AddObject(resultout);
	}

	/*Assign output pointer*/
	return newresults;
}
/*}}}*/
