/*!\file: thermal_core.cpp
 * \brief: core of the thermal solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"

void thermal_core(FemModel* femmodel){

	int i;

	/*intermediary*/
	double time;
	int    verbose;
	int    nsteps;
	double ndt;
	double dt;
	double melting_offset;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&ndt,NdtEnum);
	femmodel->parameters->FindParam(&dt,DtEnum);

	/*Compute number of time steps: */
	if((dt==0)|| (ndt==0)){
		dt=0;
		nsteps=1;
	}
	else nsteps=(int)(ndt/dt);

	/*Loop through time: */
	for(i=0;i<nsteps;i++){
		
		if(verbose)_printf_("time step: %i/%i\n",i+1,nsteps);
		time=(i+1)*dt;

		if(verbose)_printf_("computing temperatures:\n");
		solver_thermal_nonlinear(NULL,NULL,femmodel,ThermalAnalysisEnum,NoneAnalysisEnum);

		if(verbose)_printf_("computing melting:\n");
		solver_linear(NULL,femmodel,MeltingAnalysisEnum,NoneAnalysisEnum);

		if(verbose)_printf_("saving results:\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,TemperatureEnum,i,time);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,MeltingRateEnum,i,time);

	}
}
