/*! \file DoubleResult.h 
 *  \brief: header file for double result object
 *  A double result object is just derived from a DoubleInput object, with additional time and step information.
 */


#ifndef _DOUBLERESULT_H_
#define _DOUBLERESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class DoubleResult: public DoubleInput,public Result{

	private: 
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		DoubleResult();
		DoubleResult(int enum_type,IssmDouble value,int step,double time);
		~DoubleResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
				/*}}}*/
		/*result virtual functions: {{{1*/
		Result* SpawnSingResult(int  index);
		Result* SpawnBeamResult(int* indices);
		Result* SpawnTriaResult(int* indices);
		/*}}}*/

};
#endif  /* _DOUBLERESULT_H */
