/*!\file:  Input.h
 * \brief abstract class for Input object
 */ 


#ifndef _INPUT_H_
#define _INPUT_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class Node;
class Result;
#include "../Node.h"
/*}}}*/

class Input: public Object{

	public: 
		
		virtual        ~Input(){};
		virtual int    Enum()=0; //object Enum
		virtual int    EnumType()=0; //type of input (vx,vy?)

		/*methods:{{{1*/
		virtual void GetParameterValue(bool* pvalue)=0;
		virtual void GetParameterValue(int* pvalue)=0;
		virtual void GetParameterValue(double* pvalue)=0;
		virtual void GetParameterValue(double* pvalue,Node* node)=0;
		virtual void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord)=0;
		virtual void GetParameterValue(double* pvalue,double* gauss)=0;
		virtual void GetParameterValue(double* pvalue,double* gauss,double defaultvalue)=0;

		virtual void GetParameterAverage(double* pvalue)=0;
		
		virtual void GetParameterValues(double* values,double* gauss_pointers, int numgauss)=0;
	
		virtual void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss)=0;
		virtual void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, double* gauss)=0;
		virtual void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, double* gauss)=0;
		virtual void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, double* gauss)=0;
		virtual void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, double* gauss)=0;
		virtual void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, double* gauss)=0;
		virtual void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, double* gauss)=0;
		virtual void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, double* gauss)=0;
		virtual void ChangeEnum(int newenumtype)=0;
		
		virtual Input* SpawnSingInput(int  index)=0;
		virtual Input* SpawnBeamInput(int* indices)=0;
		virtual Input* SpawnTriaInput(int* indices)=0;
		virtual Result* SpawnResult(int step, double time)=0;
		virtual int  PatchSize(void)=0;
		virtual void PatchFill(double* patch, int max_vertices,Parameters* parameters)=0;


		/*}}}*/

};
#endif
