/*!\file:  PatchesSize.cpp
 * \brief  determine size of patches from inputs
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "PatchesSize"

#include "./InputToResultx.h"
#include "../../DataSet/DataSet.h"

void PatchesSize(DataSet* elements,int* pnumrows, int* pnumvertices, int* pnumnodes,int enum_type){

	int i;

	/*output: */
	int numrows;
	int numvertices;
	int numnodes;

	/*intermediary:*/
	Element* element=NULL;
	int element_numvertices;
	int element_numnodes;
	
	/*Go through elemnets, and each time an element holds an input with the correct enum_type, increase numrows by 1. At the 
	 * same time, retrieve number of vertices this element holds, as well as number of nodes the input holds values for. 
	 * Update the values of numvertices and numnodes to be the max of all the input numvertices and numnodes:*/
	
	numrows=0;
	numvertices=0;
	numnodes=0;

	for(i=0;i<elements->Size();i++){

		element=(Element*)elements->GetObjectByOffset(i);
		element->PatchSize(&numrows,&element_numvertices,&element_numnodes,enum_type);
		
		if(element_numvertices>numvertices)numvertices=element_numvertices;
		if(element_numnodes>numnodes)numnodes=element_numnodes;

	}

	/*Assign output pointers:*/
	*pnumrows=numrows;
	*pnumvertices=numvertices;
	*pnumnodes=numnodes;
}

